package com.zjty.adaptationmaster.adaptor.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.nio.file.Path;
import java.util.List;

@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Report {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    private Language language;//语言
    private String framework;//架构
    private Separate isSeparate;//前后端是否分离
    private DatabaseType databaseType;//数据库类型
    private String compileFilePath;//项目编译文件，如果是maven项目，用maven编译，那么就是pom.xml
    public DependenceManagement dependenceManagement;//版本管理方式
    @ElementCollection
    public List<String> jarPath;//依赖文件的地址列表，用于编译，如果不是用版本管理工具
    private String packagePath;

    public enum DependenceManagement{
        MAVEN,GRADLE,ANT
    }
    public enum Separate{
        WHOLE,SEPARATE
    }
    public enum DatabaseType{
        MYSQL,ORACLE,SQLSERVER,POSTGRE
    }
    public enum Language{
        JAVA,PYTHON,CPP
    }
}
