package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.github.wenhao.jpa.Specifications;
import com.zjty.adaptationmaster.adaptor.entity.ListResponse;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.entity.RuleSet;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.service.ProjectService;
import com.zjty.adaptationmaster.base.enums.Const;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.ApusicDeployer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static java.util.stream.Collectors.toList;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-07 11:06
 */
@Service
public class ProjectServiceImpl implements ProjectService {

    private final ProjectDao projectDao;

    @Autowired
    public ProjectServiceImpl(ProjectDao projectDao) {
        this.projectDao = projectDao;
    }

    @Override
    public ServerResponse saveProject(Project project) {
        if(project.getId() == null){
            project.setUpdateTime(new Date());
        }
        List<Rule> rules = project.getRules();
        if(rules != null)
        rules.forEach(rule -> rule.setProject(project));
        Project save = projectDao.save(project);
        return ServerResponse.success("项目创建成功",filter(save));
    }

    @Override
    @Transactional
    public ServerResponse deleteProject(Integer id) {
        Project project = projectDao.getOne(id);
        project.setStatus(0);
        project.setUpdateTime(new Date());
        return ServerResponse.success("删除成功");
    }

    @Override
    public ServerResponse findProject(Integer page,Project project) {
        Specification<Project> spec = Specifications.<Project>and()
                .like(project.getProjectName()!=null,"projectName","%"+project.getProjectName()+"%")
                .eq("status",1)
                .build();
        Pageable pageable = PageRequest.of(page-1, 10, Sort.Direction.DESC, "id");
        List<Project> projects = projectDao.findAll(spec,pageable).getContent();
        for (Project pro:projects) {
            filter(pro);
        }
        return ServerResponse.success(new ListResponse<>(projectDao.count(spec),projects));
    }

    /**
     * 过滤被删除的规则和规则集
     * @param pro
     * @return
     */
    private Project filter(Project pro){
        //过滤删除的规则集
        List<RuleSet> ruleSets = pro.getRuleSets();
        if(ruleSets != null && ruleSets.size() > 0){
            List<RuleSet> sets = new ArrayList<>();
            for (RuleSet set :ruleSets) {
                set.ruleSetView();
                if(set.getStatus() == 1){
                    sets.add(set);
                }
            }
            pro.setRuleSets(sets);
        }
        //过滤删除的自定义规则
        List<Rule> rules = pro.getRules();
        if(rules != null && rules.size() > 0){
            List<Rule> collect = rules.stream().filter(rule -> rule != null && rule.getStatus() != 0).collect(toList());
            pro.setRules(collect);
        }
        return pro;
    }

    @Override
    public ServerResponse deployList() {
        return ServerResponse.success(new ApusicDeployer(Const.CTLPATH,Const.MAVENHOME).list());
    }
}
