package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.db.DBConfig;
import com.zjty.adaptationmaster.adaptor.service.DBConfigService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/dbConfig")
public class DBConfigController {
    @Autowired
    private DBConfigService dbConfigService;

    @PostMapping("/save")
    public ServerResponse save(@RequestBody DBConfig dbConfig){
        return dbConfigService.saveDatabase(dbConfig);
    }

    @PutMapping("/delete")
    public ServerResponse delete(@RequestBody Integer id){
        return dbConfigService.deleteDatabase(id);
    }

    @GetMapping("/find")
    public ServerResponse find(){
        return dbConfigService.findDatabase();
    }
}
