package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.Dependency;
import com.zjty.adaptationmaster.adaptor.service.DependencyService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-09 11:02
 */
@RestController
@RequestMapping("/dependency")
@Api(tags = "依赖管理")
public class DependencyController {
    private final DependencyService dependencyService;

    @Autowired
    public DependencyController(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    @PostMapping
    public ServerResponse saveDependency(@RequestBody Dependency dependency , MultipartHttpServletRequest request){
        return dependencyService.saveDependency(dependency,request);
    }

    @DeleteMapping("/{id}")
    public ServerResponse deleteDependency(@PathVariable("id") Integer id){
        return dependencyService.deleteDependency(id);
    }


    @PostMapping("/query")
    public ServerResponse findDependency(@RequestBody Dependency dependency){
        return dependencyService.findDependency(dependency);
    }
}
