package com.zjty.adaptationmaster.adaptor.repository;

import com.zjty.adaptationmaster.adaptor.entity.db.DBConfig;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface DBConfigDao extends JpaRepository<DBConfig,Integer>, JpaSpecificationExecutor {

    List<DBConfig> findDBConfigsByStatus(Integer status);

    DBConfig findDBConfigByDbTypeAndStatus(String dbType,Integer status);

    @Query("update DBConfig d set d.status =:status where d.id =:id")
    @Modifying
    void delete(@Param(value = "id") Integer id, @Param(value = "status") Integer status);
}
