package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.entity.db.DBConfig;
import com.zjty.adaptationmaster.adaptor.repository.DBConfigDao;
import com.zjty.adaptationmaster.adaptor.service.DBConfigService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DBConfigServiceImpl implements DBConfigService {

    @Autowired
    private DBConfigDao dbConfigDao;
    /**
     * 保存配置
     * @param dbConfig
     * @return
     */
    @Override
    public ServerResponse saveDatabase(DBConfig dbConfig) {
        return ServerResponse.success(dbConfigDao.save(dbConfig));
    }

    /**
     * 删除配置
     * @param id
     * @return
     */
    @Override
    public ServerResponse deleteDatabase(Integer id) {
        dbConfigDao.delete(id,0);
        return ServerResponse.success(id);
    }

    @Override
    public ServerResponse findDatabase() {
        return ServerResponse.success(dbConfigDao.findDBConfigsByStatus(1));
    }
}
