package com.zjty.adaptationmaster.adaptor.service.Impl;


import com.zjty.adaptationmaster.adaptor.entity.db.DBManage;
import com.zjty.adaptationmaster.adaptor.repository.DBManageDao;
import com.zjty.adaptationmaster.adaptor.service.DBManageService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DBManageServiceImpl implements DBManageService {

    @Autowired
    private DBManageDao databaseDao;

    /**
     * 新增数据库
     * @param databaseManagement
     * @return
     */
    @Override
    @Transactional
    public ServerResponse saveDatabase(DBManage databaseManagement) {
        databaseManagement.setStatus(1);//1-未删除
        return ServerResponse.success(databaseDao.save(databaseManagement));
    }


    /**
     * 根据id删除
     * @param id
     * @return
     */
    @Override
    @Transactional
    public ServerResponse deleteDatabase(Integer id) {
        databaseDao.delete(id,0);//逻辑删除
        return ServerResponse.success(id);
    }

    /**
     * 查找未被逻辑删除
     * @return
     */
    @Override
    public ServerResponse findDatabase() {
        return ServerResponse.success(databaseDao.findDatabaseManagementByStatus(1));
    }

}
