package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.*;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Properties;


public class ReadedFileTask implements Runnable {

    private String projectName;
    private String uuid;
    private List<ReadedFile> readedFiles;
    //private Writer responseWriter;
    public ReadedFileTask(List<ReadedFile> readedFiles,String projectName,String uuid) {
        //System.out.println("一个线程");
        this.readedFiles = readedFiles;
        for(ReadedFile file:readedFiles){
            System.out.println(file.path);
        }
        this.projectName = projectName;
        this.uuid = uuid;
    }

    private WriterBySort bySort;
    private int index;

    public void setBySort(WriterBySort bySort) {
        System.out.println("线程遇到大文件");
        this.bySort = bySort;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void run() {
        System.out.println("进来线程");
        for(ReadedFile readedFile:readedFiles) {
            if(readedFile.path.toString().endsWith(".properties")){
                Properties properties = new Properties();
                OutputStream stream =null;
                try {
                    properties.load(new ByteArrayInputStream(readedFile.content.getBytes()));
                    for (Rule entity : readedFile.getThisMatchedRule()) {

                        //if(properties.getProperty(entity.getTarget())!=null) {
                            properties.setProperty(entity.getTarget(), entity.getReplacing());
                        //}
                        System.out.println("属性修改后"+properties.getProperty(entity.getTarget()));
                    }
                    readedFile.getPath().toFile().createNewFile();
                    stream = new FileOutputStream(readedFile.getPath().toFile());
                    System.out.println(properties);
                    properties.store(stream,"111");
                } catch (FileNotFoundException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }finally {
                    try {
                        stream.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            String content = readedFile.getContent();
            System.out.println("规则数量" + readedFile.getThisMatchedRule().size());
            for (Rule entity : readedFile.getThisMatchedRule()) {
                //在改动的地方加日志
//                int i = content.indexOf(entity.getTarget());
//                int i1 = content.lastIndexOf("\\r\\n", i);
//
                content = content.replaceAll(entity.getTarget(),entity.getReplacing());
            }
            try {
                if (bySort != null) {
                    bySort.insert(index, content);
                } else {
                    WebSocketServer.sendInfo(uuid, readedFile.getPath().getFileName() + "", "替换", "正在写出", projectName);
                    File file = readedFile.getPath().toFile();
                    file.createNewFile();
                    OutputStreamWriter contentWriter = new OutputStreamWriter(new FileOutputStream(file));
                    contentWriter.write(content);
                    contentWriter.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }

        }
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ReadedFile {
        private String content;
        private BasicFileAttributes attributes;
        private Path path;
        private List<Rule> thisMatchedRule;
    }
}
