package com.zjty.adaptationmaster.adaptor.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-07 16:35
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class RuleSet {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    private String name;//规则集名称

    private String des;//规则集描述

    private Integer status = 1;//状态（0：删除 1：未删除）

    @JsonIgnore
    @ManyToMany(mappedBy = "ruleSets")
    private List<Project> projects;//所属项目

    @OneToMany(mappedBy = "ruleSet", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private List<Rule> ruleList;//规则

    /**
     * 项目中的规则集的列表视图
     */
    public void ruleSetView(){
        projects = null;
        ruleList = null;
    }

}
