package com.zjty.adaptationmaster.utils;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.zjty.adaptationmaster.base.response.FileServerResponse;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.*;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

/**
 * Description : http请求发送工具类
 *
 * @Date : 2017/12/15 10:28
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 */
public class HttpClientUtil {

  public static String postJson(String url, String jsonArgs) throws UnsupportedEncodingException {
    RestTemplate restTemplate = new RestTemplate();
    restTemplate
        .getMessageConverters()
        .set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    // 设置请求体
    HttpHeaders headers = new HttpHeaders();
    MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
    headers.setContentType(type);
    headers.add("Accept", MediaType.APPLICATION_JSON.toString());
    // 设置请求数据
    HttpEntity<String> formEntity = new HttpEntity<>(jsonArgs, headers);
    String result = restTemplate.postForObject(url, formEntity, String.class);
    return result;
  }

  /**
   * 上传文件到服务器
   *
   * @param jarFile 文件对象
   * @param dirName 分类的目录名,例如templates,用于在文件服务器中建立对应的文件夹
   * @param fileName 原始文件名
   * @return {@link FileServerResponse}
   */
  public static FileServerResponse uploadFileToServer(
          MultipartFile jarFile, String dirName, String fileName) {
    RestTemplate restTemplate = new RestTemplate();
    restTemplate
        .getMessageConverters()
        .set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    String url = "http://127.0.0.1:8888/upload/files";
    HttpHeaders headers = new HttpHeaders();

    // 构建本地临时文件,作为中转站,到后面会删除x
    String tempFileName = jarFile.getOriginalFilename();
    String tempFilePath = "E:\\temFiles\\" + tempFileName;
    File tempFile = new File(tempFilePath);
    try {
      jarFile.transferTo(tempFile);
    } catch (IOException e) {
      e.printStackTrace();
    }

    // 设置restTemplate发送的header和相关数据
    FileSystemResource fileSystemResource = new FileSystemResource(tempFilePath);
    MediaType type = MediaType.parseMediaType("multipart/form-data");
    headers.setContentType(type);
    String cd = "filename=\"" + jarFile.getOriginalFilename() + "\"";
    headers.add("Content-Disposition", cd);

    MultiValueMap<String, Object> form = new LinkedMultiValueMap<>();
    form.add("file", fileSystemResource);
    form.add("dirName", dirName);
    form.add("fileName", fileName);
    HttpEntity<MultiValueMap<String, Object>> params = new HttpEntity<>(form, headers);
    // 发送http post请求
    String result = restTemplate.postForObject(url, params, String.class);

    // 解析文件服务器返回结果对象(code,msg,data)
    FileServerResponse fileServerResponse =
        JSON.parseObject(result, new TypeReference<FileServerResponse>() {});
    return fileServerResponse;
  }

  /**
   * @param dirName 在文件服务器中的目录名
   * @param serverFileName 在服务器中的文件名
   * @return {@link FileServerResponse}
   */
  public static FileServerResponse daleteFileToServer(String dirName, String serverFileName) {
    // 初始化的设置
    RestTemplate restTemplate = new RestTemplate();
    restTemplate
        .getMessageConverters()
        .set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    String url = "http://127.0.0.1:8888/delete";
    HttpHeaders headers = new HttpHeaders();

    //设置 header 提交方式都是表单提交
    headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);

    //  封装参数，千万不要替换为Map与HashMap，否则参数无法传递
    MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
    params.add("dirName", dirName);
    params.add("serverFileName", serverFileName);
    HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<>(params, headers);

    //  执行HTTP请求
    ResponseEntity<String> response =
        restTemplate.exchange(url, HttpMethod.POST, requestEntity, String.class);

    // 解析文件服务器返回结果对象(code,msg,data)
    FileServerResponse fileServerResponse =
        JSON.parseObject(response.getBody(), new TypeReference<FileServerResponse>() {});
    return fileServerResponse;
  }
}
