package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.zjty.adaptationmaster.adaptor.entity.db.*;
import com.zjty.adaptationmaster.adaptor.repository.DBManageDao;
import com.zjty.adaptationmaster.adaptor.repository.DBRecordDao;
import com.zjty.adaptationmaster.adaptor.service.DBMigrateService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Regular;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

@Service
@Slf4j
public class DBMigrateServiceImpl implements DBMigrateService {

    @Autowired
    private DBManageDao dbManageDao;
    @Autowired
    private DBRecordDao dbRecordDao;

    @Value("${highgo.driver}")
    private String highgoDriver;
    @Value("${highgo.connectionType}")
    private String highgoConnnectionType;
    @Value("${highgo.dbName}")
    private String highgoDBName;

    /**
     * 创建新数据库和数据库中的表
     */
    @Override
    public ServerResponse dbMigrate(DatabaseResponse databaseResponse) {
        if(databaseResponse != null && databaseResponse.getDatabaseName() != null){
            String databaseName = databaseResponse.getDatabaseName();
            //查询新建的数据库是否存在
            ServerResponse serverResponse = findDBByDBType(databaseResponse.getId());
            String data = serverResponse.getData().toString();
            String dbName = data.substring(data.indexOf("[") + 1,data.lastIndexOf("]"));
            String[] dbNameArray = dbName.split(",");
            List<String> dbNameList1 = Arrays.asList(dbNameArray);
            List<String> dbNameList = new ArrayList<>();
            dbNameList1.forEach(db -> dbNameList.add(db.trim()));
            if(dbNameList != null && dbNameList.size() != 0 && dbNameList.contains(databaseName)){
                log.info("该数据库已存在，请重新填写数据库名称");
                return ServerResponse.error("该数据库已存在，请重新填写数据库名称");
            }
            //转换后的.sql返回值
            String path = "";
            //根据传入的生成数据库类型，查找未被删除的配置文件
            DBManage databaseManagement = dbManageDao.findDBManageByIdAndStatus(databaseResponse.getId(),1);
            //mysql数据库
            if(databaseResponse.getCreateType().equals("highgo") && databaseResponse.getSourceType().equals("mysql")){
                //生成数据库的名称
                //连接系统数据库，建立新数据库
                databaseManagement.setDatabaseName(highgoDBName);
                databaseManagement.setDriver(highgoDriver);
                databaseManagement.setConnectionType(highgoConnnectionType);
                Connection connection = Regular.databaseConnection(databaseManagement);
                boolean errorOccur = false;
                if(connection != null){
                    PreparedStatement preparedStatement = null;
                    try {
                        String createDatabase = "CREATE DATABASE \"" + databaseName + "\" WITH OWNER = \"" + databaseManagement.getUserName() + "\" ENCODING = 'UTF8' TEMPLATE template0;";
                        preparedStatement = connection.prepareStatement(createDatabase);
                        preparedStatement.execute();
                    } catch (SQLException e) {
                        e.printStackTrace();
                        log.info("创建数据库：" + databaseName + "出错");
                        errorOccur = true;
                    }finally {
                        try {
                            preparedStatement.close();
                            connection.close();
                            if(errorOccur){
                                return ServerResponse.error("创建数据库：" + databaseName + "出错");
                            }
                        } catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    //建立表及导入数据
                    DBManage dbManage1 = new DBManage();
                    BeanUtils.copyProperties(databaseManagement,dbManage1);
                    dbManage1.setDatabaseName(databaseName);
                    Connection connection1 = Regular.databaseConnection(dbManage1);
                    if(connection1 != null){
                        path = Regular.mySqlRegular(databaseResponse.getSqlPath(),databaseName);
                        File file = new File(path);
                        FileReader fileReader = null;
                        BufferedReader bufferedReader = null;
                        PreparedStatement preparedStatement1 = null;
                        try {
                            fileReader = new FileReader(file);
                            bufferedReader = new BufferedReader(fileReader);
                            String s;
                            String sql = "";
                            while ((s = bufferedReader.readLine()) != null){
                                try {
                                    sql += s;
                                    if(s.contains(";")){
                                        preparedStatement1 = connection1.prepareStatement(sql);
                                        preparedStatement1.execute();
                                        sql = "";
                                    }
                                }catch (SQLException e) {
                                    log.info("sql执行出错语句：" + sql);
                                    sql = "";
                                    e.printStackTrace();
                                    continue;
                                }
                            }
                            log.info(databaseResponse.getSqlPath() + "执行完成");
                        } catch (Exception e) {
                            e.printStackTrace();
                        } finally {
                            try {
                                bufferedReader.close();
                                fileReader.close();
                                preparedStatement1.close();
                                connection1.close();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }else {
                    return ServerResponse.error("创建数据库时连接数据库失败");
                }
            }
            //保存迁移记录到数据库
            DBRecord dbRecord = new DBRecord();
            if(databaseResponse.getSourceType() != null){
                dbRecord.setSourceType(databaseResponse.getSourceType());
            }
            if(databaseResponse.getCreateType() != null){
                dbRecord.setCreateType(databaseResponse.getCreateType());
            }
            if(databaseResponse.getDatabaseName() != null){
                dbRecord.setDbName(databaseResponse.getDatabaseName());
            }
            if(databaseManagement.getUserName() != null){
                dbRecord.setUserName(databaseManagement.getUserName());
            }
            if(databaseResponse.getSqlPath() != null){
                dbRecord.setSqlPath(databaseResponse.getSqlPath());
            }
            dbRecord.setCreateSqlPath(path);
            dbRecord.setCreateTime(new Date());
            dbRecord.setStatus(1);//未删除
            dbRecordDao.save(dbRecord);
        }
        return ServerResponse.success();
    }

    /**
     * 根据传入的数据库类型查询所有的数据库
     * @param id
     * @return
     */
    @Override
    public ServerResponse findDBByDBType(Integer id) {
        List<String> dbNameList = new ArrayList<>();
        DBNameReturn dbNameReturn = new DBNameReturn();
        DBManage databaseManagement = dbManageDao.findDBManageByIdAndStatus(id, 1);
        //highgo查询所有数据库
        if(databaseManagement.getDatabaseType().equals("highgo")){
            databaseManagement.setDatabaseName(highgoDBName);
            databaseManagement.setDriver(highgoDriver);
            databaseManagement.setConnectionType(highgoConnnectionType);
            Connection connection = Regular.databaseConnection(databaseManagement);
            if (connection != null) {
                dbNameReturn.setStatus(1);
                PreparedStatement preparedStatement = null;
                try {
                    String findDB = "select p.datname from pg_database p where p.datistemplate = false;";
                    preparedStatement = connection.prepareStatement(findDB);
                    preparedStatement.execute();
                    ResultSet resultSet = preparedStatement.getResultSet();
                    while (resultSet.next()){
                        dbNameList.add(resultSet.getString(1));
                    }
                } catch (SQLException e) {
                    e.printStackTrace();
                } finally {
                    try {
                        preparedStatement.close();
                        connection.close();
                    } catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }else {
                dbNameReturn.setStatus(0);//未连接
            }
        }
        dbNameReturn.setDbName(dbNameList);
        return ServerResponse.success(dbNameReturn);
    }
}
