package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.service.Impl.Adaptor;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.*;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;


public class ReadedFileTask implements Runnable {

    private String projectName;
    private String uuid;
    private List<ReadedFile> readedFiles;
    //private Writer responseWriter;
    public ReadedFileTask(List<ReadedFile> readedFiles,String projectName,String uuid) {
        this.readedFiles = readedFiles;
        this.projectName = projectName;
        this.uuid = uuid;
    }

    private Adaptor.WriterBySort bySort;
    private int index;

    public void setBySort(Adaptor.WriterBySort bySort) {
        this.bySort = bySort;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void run() {
        for(ReadedFile readedFile:readedFiles){
            String content = readedFile.getContent();
            System.out.println("规则数量"+readedFile.getThisMatchedRule().size());
            for(Rule entity:readedFile.getThisMatchedRule()){
                System.out.println("文本匹配方式"+entity.getTextMatching());
                switch (entity.getTextMatching()){
                    case AREA:
                        String[] split = entity.getTarget().split("\\|\\|");
                        String begin = split[0];
                        String matching = split[1];
                        String end = split[2];
                        System.out.println(begin+"||"+matching+"||"+end);

                        int i = content.indexOf(matching);
                        if(i>-1){
                            WebSocketServer.sendInfo(uuid,readedFile.getPath().getFileName()+":"+matching+" 替换为 "+entity.getReplacing(),"替换","正在替换",projectName);
                            int beginIndex = content.lastIndexOf(begin, i);
                            int endIndex = content.indexOf(end, i + 1);
                            if(beginIndex>-1&&endIndex>-1){
                                content = content.substring(0,beginIndex)+entity.getReplacing()+content.substring(endIndex+end.length());
                            }
                        }
                }
                //container.add(readedFile.getPath().getFileName()+"文本替换："+entity.getTextMatching()+"|"+entity.getReplacing());

                //template.convertAndSend("===="+readedFile.getPath().getFileName()+"////"+entity.getTextMatching()+"||||"+entity.getReplacing(),"1L");
                //responseWriter.write("===="+readedFile.getPath().getFileName()+"////"+entity.getTextMatching()+"||||"+entity.getReplacing());

            }
            try {
                if(bySort!=null){
                    System.out.println("toBySort");
                    bySort.insert(index,content);
                } else {
                    System.out.println("writerFile");
                    WebSocketServer.sendInfo(uuid,readedFile.getPath().getFileName()+"","替换","正在写出",projectName);
                    File file = readedFile.getPath().toFile();
                    file.createNewFile();
                    OutputStreamWriter contentWriter = new OutputStreamWriter(new FileOutputStream(file));
                    contentWriter.write(content);
                    contentWriter.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ReadedFile {
        private String content;
        private BasicFileAttributes attributes;
        private Path path;
        private List<Rule> thisMatchedRule;
    }
}
