package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.db.DatabaseResponse;
import com.zjty.adaptationmaster.adaptor.service.DBMigrateService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RequestMapping("/dbMigrate")
@RestController
public class DBMigrateController {

    @Autowired
    private DBMigrateService dbMigrateService;

    @PostMapping("/migrate")
    public ServerResponse addDatabase(@RequestBody DatabaseResponse databaseResponse){
        return dbMigrateService.dbMigrate(databaseResponse);
    }

    @PutMapping("/find")
    public ServerResponse find(@RequestBody Integer id){
        return dbMigrateService.findDBByDBType(id);
    }

}
