package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.db.DBDeleteResponse;
import com.zjty.adaptationmaster.adaptor.entity.db.DBManage;
import com.zjty.adaptationmaster.adaptor.service.DBManageService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/database")
public class DBManageController {

    @Autowired
    private DBManageService databaseService;

    @PostMapping("/save")
    public ServerResponse add(@RequestBody DBManage databaseManagement){
        return databaseService.saveDatabase(databaseManagement);
    }

    @PutMapping("/delete/{id}")
    public ServerResponse delete(@PathVariable("id") Integer id){
        return databaseService.deleteDatabase(id);
    }

    @GetMapping("/find")
    public ServerResponse findDatabaseManagement(){
        return databaseService.findDatabase();
    }

    @PutMapping("/deleteDB")
    public ServerResponse deleteDB(@RequestBody DBDeleteResponse dbDeleteResponse){
        return databaseService.deleteDB(dbDeleteResponse);
    }
}
