package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.AdaptRequest;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Report;
import com.zjty.adaptationmaster.adaptor.service.InspectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/inspect")
public class InspectController {
    @Autowired
    private InspectService inspectService;

    @PutMapping("/inspect")
    public ServerResponse inspect(@RequestBody AdaptRequest adaptRequest){
        return inspectService.inspect(adaptRequest.getProject(),adaptRequest.getUuid());
    }

    @GetMapping("/{id}")
    public ResponseEntity report(@PathVariable Integer id){
        return ResponseEntity.ok(inspectService.getReportById(id));
    }
}
