package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Report;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.entity.pomEntity.ProjectPom;
import com.zjty.adaptationmaster.adaptor.entity.pomEntity.SecondFloor.PomDependency;
import com.zjty.adaptationmaster.base.enums.Const;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.yaml.snakeyaml.Yaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.*;

/**
 * 项目体检，根据既定特征值，
 * 扫描、统计、分析项目特征，
 * 生成报告VO
 *
 */
public class Inspector {

    public static void main(String[] args) {
        System.out.println(LocalDateTime.now());
        //System.out.println("请输入项目地址，然后回车");
        //Scanner scanner = new Scanner(System.in);
        //String next = scanner.next();
        //Project project = new Project();
        //project.setCodeUrl(next);


//        Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
//        suffixLanguageMapping.put("java",Report.Language.JAVA);
//        suffixLanguageMapping.put("cpp",Report.Language.CPP);
//        suffixLanguageMapping.put("py",Report.Language.PYTHON);
//        suffixLanguageMapping.put("jsp",Report.Language.JSP);
//        suffixLanguageMapping.put("html",Report.Language.ONLYVIEW);
//        suffixLanguageMapping.put("js",Report.Language.JAVASCRIPT);
//        suffixLanguageMapping.put("go",Report.Language.GO);
//
//        List<Rule> ruleList = new ArrayList<>();
//        //com.mysql.cj.jdbc.Driver//com.mysql.jdbc.Driver
//        ruleList.add(new Rule("com.mysql.cj.jdbc.Driver","建议修改为postgresql数据库驱动"));
//        ruleList.add(new Rule("com.mysql.jdbc.Driver","建议修改为postgresql数据库驱动"));
//        //net.sourceforge.jtds.jdbc.Driver//sqlserver
//        ruleList.add(new Rule("net.sourceforge.jtds.jdbc.Driver","建议修改为postgresql数据库驱动"));
//        //COM.ibm.db2.jdbc.app.DB2Driver//com.ibm.db2.jcc.DB2Driver//COM.ibm.db2.jdbc.net.DB2Driver//com.ibm.db2.jcc.DB2Driver
//        ruleList.add(new Rule("DB2Driver","建议修改为postgresql数据库驱动"));
//        //oracle.jdbc.OracleDriver//oracle.jdbc.driver.OracleDriver
//        ruleList.add(new Rule("OracleDriver","建议修改为postgresql数据库驱动"));
//
//        ruleList.add(new Rule("mysql-connector-java","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.microsoft.sqlserver","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.oracle","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.mariadb.jdbc","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.sap.cloud.db.jdbc","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.ibm.informix","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.firebirdsql.jdbc","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.hsqldb","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("com.h2database","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.apache.derby","建议修改为postgresql依赖声明"));
//        ruleList.add(new Rule("org.mongodb","建议修改为postgresql依赖声明"));
//
//        ruleList.add(new Rule("public native","这里用到了JNI"));
//        ruleList.add(new Rule("<packaging>jar</packaging>","建议修改打包方式为war包并排除掉springboot内置的tomcat,以部署到国产化中间件上"));
//        ruleList.add(new Rule("WebOffice","这里用到了weboffice文档展示编辑插件"));
//        ruleList.add(new Rule("pdfobject.min.js","这里用到了pdf文档展示插件"));
//        ruleList.add(new Rule("pdfobject.js","这里用到了pdf文档展示插件"));
//        ruleList.add(new Rule(".swf","这里用到了flash流媒体播放插件"));

//        //String[] projectSrc = {"D:\\project\\testAccess\\rhasspy-master"};
//        //多个子项目
//        String[] projectSrc = {"D:\\project\\testAccess\\SpringBoot-Labs-master"/*"D:\\project\\bservice","D:\\project\\debug","D:\\project\\glutton"*/};
//        //String[] projectSrc = {"D:\\project\\testAccess\\Telegram-master"};
//        for(String s:projectSrc){
//            Project project = new Project();
//            project.setCodeUrl(s);
//            Inspector inspector = new Inspector(project,suffixLanguageMapping,ruleList);
//            Report inspect = inspector.inspect();
//            System.out.println("语言："+inspect.getLanguage()+" 数据库："+inspect.getDatabaseType()+" 依赖管理："+inspect.getDependenceManagement()+" 文件数量："+inspect.getFileNum()+" 代码行数："+inspect.getLineNum());
//            for(Warn warn:inspect.getWarnList()){
//                System.out.println("\t"+warn);
//            }
//            //System.out.println(inspect);
//        }
//        System.out.println(LocalDateTime.now());
    }

    private String uuid;
    private Project project;
    private Report report;
    private Map<String, Counter> languageMatchMap;
    private Map<String, Report.Language> suffixLanguageMapping;

    private List<Rule> ruleList;

    private Map<String,List<Path>> configFileTypePathsMapping;
    private List<Warn> warnList;

    public Inspector(Project project,Map<String,Report.Language> suffixLanguageMapping,List<Rule> ruleList,String uuid){
        this.uuid = uuid;
        this.project = project;
        this.suffixLanguageMapping = suffixLanguageMapping;
        this.ruleList = ruleList;
        this.languageMatchMap = new HashMap<>();
        for(String s:suffixLanguageMapping.keySet()){
            languageMatchMap.put(s,new Counter());
        }
        /**
         * 如果存在html文件，不一定是前端代码，
         * 如果只存在html文件，不存在其他类型文件，大概率是前端代码
         * 策略：
         *      先检测是否存在html文件，如果存在，假定为前端项目
         *      然后检测其他条件，如果符合，将假定冲掉
         */
        languageMatchMap.put("html",new Counter());
        this.configFileTypePathsMapping = new HashMap<>();
        configFileTypePathsMapping.put("xml",new ArrayList<>());
        configFileTypePathsMapping.put("properties",new ArrayList<>());
        configFileTypePathsMapping.put("yml",new ArrayList<>());
        this.report = new Report();
        this.warnList = new ArrayList<>();
    }

    int fileNum = 0;
    long lineNum = 0;
    /**
     * FileVisitResult.CONTINUE 继续遍历
     * FileVisitResult.TERMINATE 中止访问
     * FileVisitResult.SKIP_SIBLINGS 不访问同级的文件或目录
     * FileVisitResult.SKIP_SUBTREE 不访问子目录
     */
    public Report inspect(){
        try {
            FileSystem aDefault = FileSystems.getDefault();
            Map<String,PathMatcher> languageSuffixMatcherMapping = new HashMap<>();
            for(String s:suffixLanguageMapping.keySet()){
                languageSuffixMatcherMapping.put(s,aDefault.getPathMatcher("glob:**/*."+s));
            }
            Map<PathMatcher,String> configFileMatcherSuffixMapping = new HashMap<>();
            for(String s:configFileTypePathsMapping.keySet()){
                configFileMatcherSuffixMapping.put(aDefault.getPathMatcher("glob:**/*."+s),s);
            }
            WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 项目评估：" + "开始读取项目文件");
            Files.walkFileTree(Paths.get(project.getCodeUrl()), new FileVisitor<Path>() {
                /**
                 * 统计某个后缀出现的次数
                 * @param dir
                 * @param attrs
                 * @return
                 * @throws IOException
                 */
                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    /**
                     * 这里是对于路径（文件夹）的过滤，在这里读不到文件
                     * 如果能判断，可以返回FileVisitResult.SKIP_SUBTREE 不访问子目录
                     */
                    //if(dir.getFileName().startsWith("."))return FileVisitResult.SKIP_SUBTREE;
                    //if (dir.endsWith(".git"))return FileVisitResult.SKIP_SUBTREE;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    fileNum++;
                    for(Map.Entry<String,PathMatcher> entry:languageSuffixMatcherMapping.entrySet()){
                        if(entry.getValue().matches(file)){
                            languageMatchMap.get(entry.getKey()).plus();
                        }
                    }
                    for(Map.Entry<PathMatcher,String> entry:configFileMatcherSuffixMapping.entrySet()){
                        if(entry.getKey().matches(file)){
                            configFileTypePathsMapping.get(entry.getValue()).add(file);
                        }
                    }

                    List<String> allLines;
                    try {
                        allLines = Files.readAllLines(file);
                    }catch (MalformedInputException e){
                        return FileVisitResult.CONTINUE;
                    }
                    lineNum += allLines.size();
                    for(int i = 0;i<allLines.size();i++){
                        String s = allLines.get(i);
                        for(Rule rule:ruleList){
                            if (s.indexOf(rule.getTarget())>-1){

                                warnList.add(new Warn(file.toString().substring(Const.UPLOAD_LOCATION.length()),i+1,rule.getTarget(),rule.getReplacing()));
                            }
                        }
                    }
                    //System.out.println(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
            WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 项目评估：" + "读取项目文件结束");
        } catch (IOException e) {
            e.printStackTrace();
        }
        return analysis();
    }

    public Report analysis(){
        try {
            WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 项目评估：" + "开始分析项目文件");
        } catch (IOException e) {
            e.printStackTrace();
        }
        report.setFileNum(fileNum);
        report.setLineNum(lineNum);
        //report.setLanguage(Report.Language.ONLYVIEW);
        Report.Language most = null;
        int maxnum = 0;
        for(Map.Entry<String,Counter> entry:languageMatchMap.entrySet()){
            if(entry.getValue().getNumber()>maxnum){
                most = suffixLanguageMapping.get(entry.getKey());
                maxnum = entry.getValue().getNumber();
            }
//            if(entry.getValue().getNumber()>0){
//                if(!entry.getKey().equals("html")){
//                    report.setLanguage(suffixLanguageMapping.get(entry.getKey()));
//                }
//            }
        }
        report.setLanguage(most==null? Report.Language.UNKNOW:most);
        /**
         * 对于具体的配置文件对应的处理方法
         * 增加要处理的文件类型需要在这里增加相应的处理方法
         */
        ArrayList<PomDependency> dependencies1 = new ArrayList<>();

        for(Map.Entry<String,List<Path>> entry:configFileTypePathsMapping.entrySet()){
            //System.out.println(entry.getKey());
            switch (entry.getKey()){
                /**
                 * 配置文件的一个类型，xml文件
                 */
                case "xml":
                    //System.out.println(entry.getValue().size());
                    for(Path path:entry.getValue()){
                        /**
                         * 对于maven工程，可以在maven配置文件中得到一这些信息
                         *      编译方式打包方式和打好的包的路径
                         */
                        if(path.getFileName().endsWith("pom.xml")){
                            report.setDependenceManagement(Report.DependenceManagement.MAVEN);
                            report.setCompileFilePath(path.toString());
                            //解析pom文件
                            ProjectPom analysis = AnalysisPom.analysis(path);
                            //设置依赖
                            List<PomDependency> dependencies = analysis.getDependencies();
                            dependencies1.addAll(dependencies);

                            SAXReader reader = new SAXReader();
                            Document document = null;
                            try {
                                document = reader.read(path.toFile());
                            } catch (DocumentException e) {
                                e.printStackTrace();
                            }
                            Element elementProject = document.getRootElement();

                            String projectMavenName = elementProject.elementText("artifactId");
                            String projectMavenVersion = elementProject.elementText("version");
                            report.setPackagePath(path.getParent()+"/target/"+projectMavenName+"-"+projectMavenVersion+".war");
                        }
                    }
                    break;
                /**
                 * properties文件
                 *
                 */
                case "properties":
                    for(Path path:entry.getValue()) {
                        /**
                         * springboot项目的配置文件一般是application.properties或application.yml
                         */
                        if (path.getFileName().endsWith("application.properties")) {
                            Properties properties = new Properties();
                            try {
                                properties.load(new FileInputStream(path.toFile()));
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                            String datasourceDriver = properties.getProperty("spring.datasource.driver-class-name");
                            String driverClassName = properties.getProperty("jdbc.driverClassName");
                            String active = properties.getProperty("spring.profiles.active");
                            if(active!=null){
                                System.out.println("生效的配置文件：" + active + path);
                                //System.out.println(path.getParent());
                                File file = new File(path.getParent().toString() + "/application-" + active + ".properties");
                                if (file.exists()) {
                                    Properties properties1 = new Properties();
                                    try {
                                        properties1.load(new FileInputStream(file));
                                        String driver = properties1.getProperty("spring.datasource.driver-class-name");
                                        if (driver != null) {
                                            datasourceDriver = driver;
                                        }
                                        String driverName = properties1.getProperty("jdbc.driverClassName");
                                        if(driverClassName != null){
                                            driverClassName = driverName;
                                        }
                                    } catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    //System.out.println("没有找到active配置文件");
                                }
                            }
                            if (datasourceDriver != null) {
                                if (datasourceDriver.contains(Report.DatabaseType.MYSQL.name().toLowerCase())) {
                                    report.setDatabaseType(Report.DatabaseType.MYSQL);
                                } else if (datasourceDriver.contains(Report.DatabaseType.POSTGRE.name().toLowerCase())) {
                                    report.setDatabaseType(Report.DatabaseType.POSTGRE);
                                } else if (datasourceDriver.contains(Report.DatabaseType.ORACLE.name().toLowerCase())) {
                                    report.setDatabaseType(Report.DatabaseType.ORACLE);
                                } else if (datasourceDriver.contains(Report.DatabaseType.SQLSERVER.name().toLowerCase())) {
                                    report.setDatabaseType(Report.DatabaseType.SQLSERVER);
                                }
                            }
                            if (driverClassName != null) {
                                if (driverClassName.contains(Report.DatabaseType.MYSQL.name().toLowerCase())) {
                                    report.setDatabaseType(Report.DatabaseType.MYSQL);
                                } else if (driverClassName.contains(Report.DatabaseType.POSTGRE.name().toLowerCase())) {
                                    report.setDatabaseType(Report.DatabaseType.POSTGRE);
                                } else if (driverClassName.contains(Report.DatabaseType.ORACLE.name().toLowerCase())) {
                                    report.setDatabaseType(Report.DatabaseType.ORACLE);
                                } else if (driverClassName.contains(Report.DatabaseType.SQLSERVER.name().toLowerCase())) {
                                    report.setDatabaseType(Report.DatabaseType.SQLSERVER);
                                }
                            }
                        }
                    }
                    break;
                case "yml":
                    for(Path path:entry.getValue()) {
                        Yaml ymal = new Yaml();
                        Iterable<Object> objects = null;
                        try {
                            objects = ymal.loadAll(new FileInputStream(path.toFile()));
                        } catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        objects.forEach(o -> {

                        });
                    }
                    break;
            }
        }
//        for(Path path:propertiesConfigPaths){
//            try {
//                for(String s:Files.readAllLines(path)){
//                    int index = StringCompareUtil.compare(s, "spring.datasource.driver-class-name");
//                    if(index > -1){
//                        if(!s.startsWith("#")){
//                            /**
//                             * MySQL数据库：
//                             *     1）驱动包：https://mvnrepository.com/artifact/mysql/mysql-connector-java（下载路径）
//                             *     2）驱动类名：com.mysql.jdbc.Driver
//                             *     3）JDBC的URL：jdbc:mysql://IP地址:端口号/数据库名字
//                             *      注：端口号缺省为：3306
//                             *
//                             * SQL server数据库：
//                             *     1）驱动包：https://mvnrepository.com/artifact/com.microsoft.sqlserver/sqljdbc4（下载路径）
//                             *     2）驱动类名：com.microsoft.jdbc.sqlserver.SQLServerDriver
//                             *     3）JDBC的URL：jdbc:microsoft:sqlserver://IP地址:端口号;DatabaseName=数据库名
//                             *     4）sqljdbc和sqljdbc4区别：https://blog.csdn.net/cainiao_M/article/details/53404222
//                             *     注：端口号缺省为：1433
//                             *
//                             * Oracle数据库：
//                             *     1）驱动包：https://mvnrepository.com/artifact/com.oracle/ojdbc6（下载路径）
//                             *     2）驱动类名：oracle.jdbc.driver.OracleDriver
//                             *     3）JDBC的URL：jdbc:oracle:thin:@IP地址:端口号:数据库名
//                             *     4）ojdbc6和ojdbc14的区别：ojdbc14.jar（适合java-1.4和1.5），ojdbc6（适合java-1.6）
//                             *     注：端口号缺省为：1521
//                             */
//                            if(StringCompareUtil.compare(s, "mysql")>-1){
//                                report.setDatabaseType(Report.DatabaseType.MYSQL);
//                            }else if(StringCompareUtil.compare(s, "sqlserver")>-1){
//                                report.setDatabaseType(Report.DatabaseType.SQLSERVER);
//                            }else if(StringCompareUtil.compare(s, "oracle")>-1){
//                                report.setDatabaseType(Report.DatabaseType.ORACLE);
//                            }else if(StringCompareUtil.compare(s, "postgre")>-1){
//                                report.setDatabaseType(Report.DatabaseType.POSTGRE);
//                            }
//                        }
//                    }
//                }
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
//        }
        try {
            WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 项目评估：" + "分析项目文件完成");
            WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 项目评估：" + "正在生成报告");
            WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 项目评估：" + "即将下载报告");
        } catch (IOException e) {
            e.printStackTrace();
        }
        report.setDependencies(dependencies1);
        report.setWarnList(warnList);
        return report;
    }
    public class Counter {
        private int i = 0;
        public void plus(){
            i++;
        }

        public int getNumber() {
            return i;
        }

        public void reset(){
            i = 0;
        }
    }
    public class YmlConfig{
        private String springDatasourceDriverClassName;
    }


    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public class Warn{
        private String path;
        private int line;
        private String keyWord;
        private String suggest;
    }

}
