package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.github.wenhao.jpa.Specifications;
import com.zjty.adaptationmaster.adaptor.entity.Dependency;
import com.zjty.adaptationmaster.adaptor.repository.DependencyDao;
import com.zjty.adaptationmaster.adaptor.service.DependencyService;
import com.zjty.adaptationmaster.base.enums.Const;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;

/**
 * <h4>Description : 依赖管理</h4>
 *
 * @author : czq
 * @Date : 2019-12-07 13:06
 */
@Service
public class DependencyServiceImpl implements DependencyService {

    private final DependencyDao dependencyDao;

    @Autowired
    public DependencyServiceImpl(DependencyDao dependencyDao) {
        this.dependencyDao = dependencyDao;
    }

    @Override
    public ServerResponse saveDependency(Dependency dependency, MultipartFile dependencyFile) {
        //上传的依赖文件和依赖包
        if (!dependencyFile.isEmpty()) {
            //依赖名称
            String originalFilename = dependencyFile.getOriginalFilename();
            assert originalFilename != null;
            dependency.setDependencyUrl("/uploads/"+originalFilename);
            dependency.setStartTime(new Date());
            try {
                InputStream inputStream = dependencyFile.getInputStream();
                Files.copy(inputStream, Paths.get(Const.UPLOAD_LOCATION, originalFilename));
                inputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        Dependency save = dependencyDao.save(dependency);
        return ServerResponse.success("上传成功",save);
    }

    @Override
    @Transactional
    public ServerResponse deleteDependency(Integer id) {
        Dependency dependency = dependencyDao.getOne(id);
        dependency.setStatus(0);
        return ServerResponse.success("删除成功");
    }

    @Override
    public ServerResponse findDependency(Dependency dependency) {
        Specification<Dependency> spec = Specifications.<Dependency>and()
                .eq(dependency.getType()!=null,"type",dependency.getType())
                .eq("status",1)
                .build();
        List<Dependency> dependencies = dependencyDao.findAll(spec);
        return ServerResponse.success(dependencies);
    }
}
