package com.zjty.adaptationmaster.adaptor.entity.db;

import com.zjty.adaptationmaster.utils.Regular;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SQLExecuteTask implements Runnable{

    private DBManage dbManage;

    private String sql;

    public SQLExecuteTask(DBManage dbManage){
        this.dbManage = dbManage;
    }
    public void setSql(String sql){
        this.sql = sql;
    }
    @Override
    public void run() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        //String unRecordSql = "SET LOCAL fsync TO OFF;";
        try {
            connection = Regular.databaseConnection(dbManage);
            //不记录日志,加快insert速度
            //preparedStatement = connection.prepareStatement(unRecordSql);
            //preparedStatement.execute();
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setQueryTimeout(10);
            preparedStatement.execute();
        } catch (SQLException e) {
            e.printStackTrace();
        }finally {
            try {
                preparedStatement.close();
                connection.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}
