package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.entity.db.DBManage;

import java.io.*;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class Regular {

    /**
     * 将mysql导出的.sql文件转为highgo可以识别的.sql文件
     * @param path  sql文件地址
     * @param sqlName   数据库名字
     */
    public static String mySqlRegular(String path,String sqlName){
        File file = new File(path);
        String savePath = file.getParent() + "/" + sqlName + ".sql";
        File saveFile = new File(savePath);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            fileWriter = new FileWriter(saveFile);
            bufferedWriter = new BufferedWriter(fileWriter);
            String s = "";
            boolean database = true;//去除.sql中使用数据库的sql语句
            String tableName = null;
            String incrementField = null;
            while ((s = bufferedReader.readLine()) != null){
                s = s.replaceAll("`","\"");
                s += "\r\n";
                //转换mysql的int和bigint类型
                if(s.contains("int(") || s.contains("INT(")){
                    String dataType = s.substring(s.lastIndexOf("\"") + 1,s.indexOf("(")).trim();
                    if(dataType.length() <= 4){
                        //int类型
                        String startChar = s.substring(0,s.indexOf("("));
                        String endChar = s.substring(s.indexOf(")") + 1);
                        s = startChar + "4" + endChar;
                        if(lowerAndUpper(s,"AUTO_INCREMENT")){
                            s = s.replace("AUTO_INCREMENT","");
                            s = s.replace("auto_increment","");
                            s = s.replace("int4","serial");
                            s = s.replace("INT4","serial");
                            incrementField = s.substring(s.indexOf("\"") + 1,s.lastIndexOf("\""));
                        }
                    }else {
                        //bigint类型
                        if(lowerAndUpper(s,"BIGINT")){
                            String startChar = s.substring(0,s.indexOf("("));
                            String endChar = s.substring(s.indexOf(")") + 1);
                            s = startChar + endChar;
                            if(lowerAndUpper(s,"AUTO_INCREMENT")){
                                s = s.replace("AUTO_INCREMENT","");
                                s = s.replace("auto_increment","");
                                s = s.replace("bigint","bigserial");
                                s = s.replace("BIGINT","bigserial");
                                incrementField = s.substring(s.indexOf("\"") + 1,s.lastIndexOf("\""));
                            }
                        }else if(lowerAndUpper(s,"SMALLINT")){
                            String startChar = s.substring(0,s.indexOf("("));
                            String endChar = s.substring(s.indexOf(")") + 1);
                            s = startChar + endChar;
                            if(lowerAndUpper(s,"AUTO_INCREMENT")){
                                s = s.replace("AUTO_INCREMENT","");
                                s = s.replace("auto_increment","");
                                s = s.replace("SMALLINT","smallserial");
                                s = s.replace("smallint","smallserial");
                                incrementField = s.substring(s.indexOf("\"") + 1,s.lastIndexOf("\""));
                            }
                        }
                    }
                }
                //转换mysql的时间datetime类型
                s = StringType(s,"datetime","timestamp");
                //转换mysql的double类型
                s = StringType(s,"double","float");
                //插入值时boolean类型转换
                if(s.contains("bit(1)")){
                    s = s.replace("bit(1)","boolean");
                }
                if(s.contains("'\\0'")){
                    s = s.replace("'\\0'","'false'");
                }
                if(s.contains("'\\1'")){
                    s = s.replace("'\\1'","true");
                }
                //mysql的外键key值
                if(lowerAndUpper(s,"KEY") && !lowerAndUpper(s,"FOREIGN") && !lowerAndUpper(s,"PRIMARY")){
                    String startChar = s.substring(0,s.indexOf("\""));
                    if(lowerAndUpper(startChar,"KEY")){
                        continue;
                    }
                }
                //记录创建表时表的名字
                if(lowerAndUpper(s,"CREATE") && lowerAndUpper(s,"TABLE")){
                    tableName = s.substring(s.indexOf("\"") + 1,s.lastIndexOf("\"")).trim();
                }
                //去除表类型的定义
                if(lowerAndUpper(s,"ENGINE") && lowerAndUpper(s,"CHARSET")){
                    if(lowerAndUpper(s,"AUTO_INCREMENT")){
                        String[] array = s.split(" ");
                        for(String a:array){
                            if(lowerAndUpper(a.trim(),"AUTO_INCREMENT")){
                                String num = a.substring(a.indexOf("=") + 1);
                                String alterIncrementInital = "SELECT setval('\"" + tableName + "_" + incrementField + "_seq\"'," +  (Integer.parseInt(num) - 1) + ", true);\r\n";
                                s = ");\r\n";
                                s = s + alterIncrementInital;
                            }
                        }
                    }else {
                        s = ");\r\n";
                    }
                }
                //去除.sql中使用数据库的sql语句
                if(s.contains("USE") && s.contains(";") && s.contains("\"") && database){
                    database = false;
                }else {
                    bufferedWriter.write(s);
                }
            }
            bufferedWriter.flush();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            try {
                bufferedReader.close();
                fileReader.close();
                bufferedWriter.close();
                fileWriter.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return savePath;
    }

    /**
     * 判断大写和小写
     */
    public static boolean lowerAndUpper(String s,String upper){
        if(s.contains(upper) || s.contains(upper.toLowerCase())){
            return true;
        }else {
            return false;
        }
    }

    /**
     * 判断出入的字符串
     * @param s
     */
    public static String StringType(String s,String lowerCase,String replacement){
        String startChar;
        String endChar;
        String upperCase = lowerCase.toUpperCase();
        if(s.contains(lowerCase)){
            //小写
            startChar = s.substring(0,s.indexOf(lowerCase));
            endChar = s.substring(s.indexOf(lowerCase) + 1);
            if(startChar.contains("\"") && !endChar.contains("\"")){
                return s.replaceAll(lowerCase,replacement);
            }
        }else if(s.contains(upperCase)){
            //大写
            startChar = s.substring(0,s.indexOf(upperCase));
            endChar = s.substring(s.indexOf(upperCase) + 1);
            if(startChar.contains("\"") && !endChar.contains("\"")){
                return s.replaceAll(upperCase,replacement);
            }
        }
        return s;
    }

    /**
     * 自增整数，转换为highgo的自增整数
     * @param s
     */
    public static String integerIncrement(String s,String integerType){
        if(lowerAndUpper(s,"AUTO_INCREMENT")){
            if(integerType.equals("int4")){
                s = s.replace(integerType,"serial");
            }else {
                s = s.replace(integerType,"bigserial");
            }
            s = s.replace("AUTO_INCREMENT","");
            s = s.replace("auto_increment","");
        }
        return s;
    }

    /**
     * 数据库连接
     * @param
     */
    public static Connection databaseConnection(DBManage databaseManagement){
        Connection connection = null;
        try {
            Class.forName(databaseManagement.getDriver());
            String connectionUrl = "jdbc:" + databaseManagement.getConnectionType() + ":" + "//" + databaseManagement.getAddress() + ":" + databaseManagement.getPort() + "/" + databaseManagement.getDatabaseName();
            connection = DriverManager.getConnection(connectionUrl,databaseManagement.getUserName(),databaseManagement.getPassword());
            return connection;
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }


    public static void main(String[] args) {
        mySqlRegular("C:\\Users\\admin\\Desktop\\2.sql","else");
    }
}
