package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.db.DBDeleteResponse;
import com.zjty.adaptationmaster.adaptor.entity.db.DBRecordPage;
import com.zjty.adaptationmaster.adaptor.service.DBRecordService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/dbRecord")
public class DBRecordController {
    @Autowired
    private DBRecordService dbRecordService;

    @PutMapping("/page")
    public ServerResponse page(@RequestBody DBRecordPage dbRecordPage){
        return dbRecordService.pageFind(dbRecordPage);
    }

    @PutMapping("deleteDB")
    public ServerResponse deleteDB(@RequestBody DBDeleteResponse dbDeleteResponse){
        return dbRecordService.deleteDB(dbDeleteResponse);
    }
}
