package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.utils.ReadedFileTask;
import com.zjty.adaptationmaster.adaptor.entity.OriginalFile;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.base.enums.Const;
import com.zjty.adaptationmaster.adaptor.repository.OriginalFileDao;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.*;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.*;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Component
public class Adaptor {
    //@Autowired
    //private AdaptationDetailLogEntityDao adaptationDetailLogEntityDao;
    @Autowired
    private OriginalFileDao originalFileDao;

    private String uuid;
    //@Value("${base.path}")
    private String basePath = Const.CONSOLE;
    //线程池数量，合适的线程数量能让程序更快
    private static final int poolSize = 20;
    //为避免内存溢出，对于超大文件，切分成部分分别读入处理，最后拼接写出
    private static final long LIMIT = 200*1024*1024;
    List<Rule> ruleList;
    Project project;
    //String projectPath;
    //private List<Rule> adaptorEntities = new ArrayList<>();

    //public void setProjectPath(String projectPath) {
    //    this.projectPath = projectPath;
    //}


    public void setProject(Project project) {
        this.project = project;
    }

    public void setRuleList(List<Rule> ruleList) {
        this.ruleList = ruleList;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void doAdapt(){
        //String regular = preprocesAdaptation();
        //List<String> strings1 = preprocessRegular();
        List<MatchAndRule> strings1 = preprocessRegular();
        System.out.println(strings1.size()+"规则数量");

        if(strings1.size()<1){
            System.out.println("检测到匹配规则为空");
            return;
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(poolSize,poolSize,10, TimeUnit.SECONDS,new ArrayBlockingQueue<>(poolSize*2));
        pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        List<OriginalFile> originalFiles = new ArrayList<>();
        //记录实际具体适配内容
        //List<AdaptationDetailsLogEntity> detailsLogEntities = new ArrayList<>();
        ReadedFileRepository repository = new ReadedFileRepository();
        String storePathParent ="originalFile/"+ UUID.randomUUID().toString();
        try {
            Files.walkFileTree(Paths.get(project.getCodeUrl()),new SimpleFileVisitor<Path>() {
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
//                    System.out.println(file);
//                    String pathString = file.toString();
//                    pathString.indexOf(System.getProperty("file.separator"),basePath.length());

                    boolean match = false;
                    List<Rule> thisFileMatched = null;
                    //不符合规则的路径过滤掉
                    for(MatchAndRule regular:strings1) {
                        if (FileSystems.getDefault().getPathMatcher("glob:"+regular.getMath()).matches(file)) {
                            if(thisFileMatched==null)thisFileMatched = new ArrayList<>();
                            thisFileMatched.add(regular.getRule());
                            match = true;
                        }
                    }

                    if(match) {
                        //System.out.println("match");
                        String storePath = storePathParent+"/"+UUID.randomUUID().toString()+"/"+file.getFileName();
                        //原先文件的新地址
                        Path originalPath = Paths.get(basePath +storePath);
                        File parentFile = originalPath.toFile().getParentFile();
                        if(!parentFile.exists()||!parentFile.isDirectory())parentFile.mkdirs();
                        OriginalFile originalFile = new OriginalFile(file.toString(),originalPath.toString(),new Date());
                        originalFiles.add(originalFile);
                        //Files.copy(file,originalPath);
                        Files.move(file, originalPath);
                        //splitedFile.setDeal(true);
                        WebSocketServer.sendInfo(uuid,"过滤得到符合规则的文件" + file,"替换","过滤文件",project.getProjectName());
                        //System.out.println();
                        if (attrs.size() > LIMIT) {
                            System.out.println("找到大文件" + file);
                            ReadedLinesRepository linesRepository = new ReadedLinesRepository();
                            int i = 0;
                            WriterBySort bySort = new WriterBySort();
                            File newFile = file.toFile();
                            newFile.createNewFile();
                            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(newFile), StandardCharsets.UTF_8);
                            bySort.setWriter(writer);
                            for (String s : Files.readAllLines(originalPath, Charset.forName("utf-8"))) {
                                if (linesRepository.put(s)) {
                                    List<ReadedFileTask.ReadedFile> readedFiles = new ArrayList<>();
                                    readedFiles.add(new ReadedFileTask.ReadedFile(linesRepository.getReadedFiles(), attrs, file,thisFileMatched));
                                    ReadedFileTask apacheTask = new ReadedFileTask(readedFiles,project.getProjectName(),uuid);
                                    apacheTask.setBySort(bySort);
                                    apacheTask.setIndex(i);
                                    pool.submit(apacheTask);
                                    i++;
                                }
                            }
                            List<ReadedFileTask.ReadedFile> readedFiles = new ArrayList<>();
                            readedFiles.add(new ReadedFileTask.ReadedFile(linesRepository.getReadedFiles(), attrs, file,thisFileMatched));
                            ReadedFileTask apacheTask = new ReadedFileTask(readedFiles,project.getProjectName(),uuid);
                            apacheTask.setBySort(bySort);
                            apacheTask.setIndex(i);
                            pool.submit(apacheTask);
                            i++;
                            bySort.setSize(i);
                        }else {
                            String s = new String(Files.readAllBytes(originalPath));
                            ReadedFileTask.ReadedFile readedFile = new ReadedFileTask.ReadedFile(s, attrs, file,thisFileMatched);
                            if (repository.put(readedFile)) {
                                ReadedFileTask apacheTask = new ReadedFileTask(repository.getReadedFiles(),project.getProjectName(),uuid);
                                pool.submit(apacheTask);
                            }
                        }
                    }/*else {
                        Files.copy(file, Paths.get(newPath));
                    }*/
                    return FileVisitResult.CONTINUE;
                }
            });
            System.out.println("遍历结束");
            ReadedFileTask apacheTask = new ReadedFileTask(repository.getReadedFiles(),project.getProjectName(),uuid);
            pool.submit(apacheTask);
            pool.shutdown();
            try {
                pool.awaitTermination(1,TimeUnit.HOURS);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            //originalFileDao.saveAll(originalFiles);
            //adaptationDetailLogEntityDao.saveAll(detailsLogEntities);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 预处理适配规则，将规则实体类处理成glob表达式
     * @return
     */
    private List<MatchAndRule> preprocessRegular() {
        //List<String> result = new ArrayList<>();
        List<MatchAndRule> result = new ArrayList<>();
        for (Rule adaptorEntity : ruleList) {
            System.out.println(adaptorEntity.getPath());
//            System.out.println(adaptorEntity.getTarget()+"11");
//            System.out.println(adaptorEntity.getPathMatchType());
//            System.out.println(adaptorEntity);
            switch (adaptorEntity.getPathMatchType()) {
                case SUFFIX:
                    result.add(new MatchAndRule("**/**" + adaptorEntity.getPath(),adaptorEntity));
                    break;
                case PATH:
                    result.add(new MatchAndRule("" + adaptorEntity.getPath(),adaptorEntity));
                    break;
                case NAME:
                    result.add(new MatchAndRule("**/" + adaptorEntity.getPath(),adaptorEntity));
                    break;
                case GLOB:
                    result.add(new MatchAndRule(adaptorEntity.getPath(),adaptorEntity));
            }
        }
        return result;
    }

    /**
     * 对于大文件，按行读取，积攒到一定大小去处理
     * 这里put进来每行
     * 大小不够时返回false
     * 大小够时返回true
     */
    private class ReadedLinesRepository{
        private static final long LIMIT = 200*1024*1024;//字节*k*m

        private List<StringBuilder> readedFiles;
        private long count;

        public String getReadedFiles() {
            return readedFiles.toString();
        }

        public boolean put(String readedFile){
            if(readedFiles==null)readedFiles = new ArrayList<>();
            readedFiles.add(new StringBuilder(readedFile));
            count+=readedFile.length();
            return count > LIMIT;
        }
    }

    /**
     * 读取到的大量小文件，积累到一定的大小，才交给一个线程去处理
     */
    private class ReadedFileRepository{
        private List<ReadedFileTask.ReadedFile> readedFiles;
        private long count;

        public List<ReadedFileTask.ReadedFile> getReadedFiles() {
            return readedFiles;
        }

        public boolean put(ReadedFileTask.ReadedFile readedFile){
            if(readedFiles==null)readedFiles = new ArrayList<>();
            readedFiles.add(readedFile);
            count+=readedFile.getAttributes().size();
            return count > LIMIT;
        }
    }

    /**
     * 过大的文件，切割成几块，每块编号，分给每个线程处理，处理结束后，按编号顺序写出
     * 这里按编号控制写出顺序
     */
    public class WriterBySort{
        private int currentIndex = -1;
        private Map<Integer,String> map = new TreeMap<>();
        private Writer contentWriter;
        private int size;

        public void setWriter(Writer writer) {
            this.contentWriter = writer;
        }
        public void setSize(int size) {
            this.size = size;
            if(currentIndex==size){
                try {
                    contentWriter.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        public void insert(Integer key, String value){
            map.put(key,value);
            while (map.get(currentIndex+1)!=null){
                try {
                    contentWriter.write(map.remove(currentIndex+1));
                } catch (IOException e) {
                    e.printStackTrace();
                }
                currentIndex++;
                if(currentIndex == size){
                    try {
                        contentWriter.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    private class MatchAndRule{
        private String math;
        private Rule rule;
    }
}
