package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Report;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.service.InspectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Inspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Service
public class InspectServiceImpl implements InspectService {
    @Autowired
    private ProjectDao projectDao;

    @Transactional
    @Override
    public ServerResponse inspect(Project project) {
        //Project project = projectDao.getOne(projectId);
        Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
        suffixLanguageMapping.put("java",Report.Language.JAVA);
        suffixLanguageMapping.put("cpp",Report.Language.CPP);
        suffixLanguageMapping.put("py",Report.Language.PYTHON);
        suffixLanguageMapping.put("jsp",Report.Language.JSP);
        //suffixLanguageMapping.put("html",Report.Language.ONLYVIEW);

        return ServerResponse.success(new Inspector(project,suffixLanguageMapping).inspect());
    }
}
