package com.zjty.adaptationmaster.adaptor.entity;

import com.zjty.adaptationmaster.adaptor.entity.pomEntity.ProjectPom;
import com.zjty.adaptationmaster.adaptor.entity.pomEntity.SecondFloor.PomDependency;
import com.zjty.adaptationmaster.utils.Inspector;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class Report {

    private Integer id;
    private Language language;//语言
    private String framework;//架构
    private DatabaseType databaseType;//数据库类型
    private int fileNum;
    private long lineNum;
    private List<PomDependency> dependencies;
    @Transient
    private ProjectPom projectPom;

    @Transient
    private List<Inspector.Warn> warnList;

    private Separate isSeparate;//前后端是否分离
    private String compileFilePath;//项目编译文件，如果是maven项目，用maven编译，那么就是pom.xml
    public DependenceManagement dependenceManagement;//版本管理方式
    @ElementCollection
    public List<String> jarPath;//依赖文件的地址列表，用于编译，如果不是用版本管理工具
    private String packagePath;
    private long createTime;

    public enum DependenceManagement{
        MAVEN,GRADLE,ANT
    }
    public enum Separate{
        WHOLE,SEPARATE
    }
    public enum DatabaseType{
        MYSQL,ORACLE,SQLSERVER,POSTGRE
    }
    public enum Language{
        JAVA,PYTHON,CPP,JSP,ASP,ONLYVIEW,UNKNOW,JAVASCRIPT,GO
    }
}
