package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.github.wenhao.jpa.Specifications;
import com.zjty.adaptationmaster.adaptor.entity.db.*;
import com.zjty.adaptationmaster.adaptor.repository.DBManageDao;
import com.zjty.adaptationmaster.adaptor.repository.DBRecordDao;
import com.zjty.adaptationmaster.adaptor.service.DBRecordService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Regular;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

@Service
public class DBRecordServiceImpl implements DBRecordService {
    @Autowired
    private DBRecordDao dbRecordDao;
    @Autowired
    private DBManageDao dbManageDao;

    /**
     *  分页条件查询
     * @param dbRecordPage
     * @return
     */
    @Override
    public ServerResponse pageFind(DBRecordPage dbRecordPage) {
        Specification<DBRecord> specifications = Specifications.<DBRecord>and()
                .eq(dbRecordPage.getCreateType() != null,"createType",dbRecordPage.getCreateType())
                .eq(dbRecordPage.getUserName() != null,"userName",dbRecordPage.getUserName())
                .eq("status",1)
                .build();
        Integer page = dbRecordPage.getPage();
        Integer size = dbRecordPage.getSize();
        if(page == null || page <= 0){
            page = 1;
        }
        if(size == null || size <= 0){
            size = 10;
        }
        Pageable pageable = PageRequest.of(page - 1,size, Sort.Direction.DESC,"createTime");
        long count = dbRecordDao.count(specifications);
        if(count < 0){
            return ServerResponse.error();
        }
        return ServerResponse.success(new DBRecordReturn(count,dbRecordDao.findAll(specifications,pageable).getContent()));
    }

    /**
     * 数据库删除
     * @param dbDeleteResponse
     * @return
     */
    @Override
    @Transactional
    public ServerResponse deleteDB(DBDeleteResponse dbDeleteResponse) {
        DBManage dbManage = dbManageDao.findDatabaseManagementByDatabaseTypeAndStatus(dbDeleteResponse.getDbType(),1);
        Connection connection = Regular.databaseConnection(dbManage);
        if (connection != null) {
            PreparedStatement preparedStatement = null;
            try {
                String findDB = "DROP DATABASE IF EXISTS " + dbDeleteResponse.getDbName()+ ";";
                preparedStatement = connection.prepareStatement(findDB);
                preparedStatement.execute();
                dbRecordDao.delete(dbDeleteResponse.getDbName(),0);
            } catch (SQLException e) {
                e.printStackTrace();
            } finally {
                try {
                    preparedStatement.close();
                    connection.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return ServerResponse.success();
    }
}
