package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.service.DeployService;
import com.zjty.adaptationmaster.base.enums.Const;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.ApusicDeployer;
import com.zjty.adaptationmaster.utils.MavenCompiler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeployServiceImpl implements DeployService {
    @Autowired
    private ProjectDao projectDao;

    @Override
    public ServerResponse compile(int projectId, String uuid) {
//        Project project = new Project();
//        project.setCompileFilePath("C:\\home\\project\\rsc\\hrmbclient\\pom.xml");
//        project.setDependenceManagement(Report.DependenceManagement.MAVEN);
        Project project = projectDao.getOne(projectId);
        if(project.getReport()==null)return ServerResponse.error("请进行项目体检或完善项目信息");
        switch (project.getReport().getDependenceManagement()) {
            case MAVEN:
                new MavenCompiler(project, Const.MAVENHOME, uuid).compiler();

        }
        return ServerResponse.success(project);
    }

    @Override
    public ServerResponse deploy(int projectId, String uuid) {
//        Project project = new Project();
//        project.setPackagePath("/home/user/Desktop/hrmanager-0.0.1-SNAPSHOT.war");
        Project project = projectDao.getOne(projectId);
        new ApusicDeployer(Const.CTLPATH,Const.MAVENHOME).deploy(project,uuid);
        return ServerResponse.success(project);
    }
}
