package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.github.wenhao.jpa.Specifications;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.entity.RuleSet;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.repository.RuleDao;
import com.zjty.adaptationmaster.adaptor.repository.RuleSetDao;
import com.zjty.adaptationmaster.adaptor.service.RuleService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import static java.util.stream.Collectors.toList;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-09 9:29
 */
@Service
public class RuleServiceImpl implements RuleService{
    
    private final RuleSetDao ruleSetDao;

    private final RuleDao ruleDao;
    
    private final ProjectDao projectDao;

    @Autowired
    public RuleServiceImpl(RuleSetDao ruleSetDao, RuleDao ruleDao, ProjectDao projectDao) {
        this.ruleSetDao = ruleSetDao;
        this.ruleDao = ruleDao;
        this.projectDao = projectDao;
    }

    @Override
    public ServerResponse addRuleSet(RuleSet ruleSet) {
        List<Rule> ruleList = ruleSet.getRuleList();
        ruleList.forEach(rule -> rule.setRuleSet(ruleSet));
        RuleSet save = ruleSetDao.save(ruleSet);
        return ServerResponse.success(filter(save));
    }

    @Override
    @Transactional
    public ServerResponse deleteRuleSet(Integer id) {
        RuleSet ruleSet = ruleSetDao.getOne(id);
        ruleSet.setStatus(0);
        return ServerResponse.success("删除规则集"+id);
    }

    @Override
    public ServerResponse findRuleSet(RuleSet ruleSet) {
        Specification<RuleSet> spec = Specifications.<RuleSet>and()
                .eq("status",1)
                .build();
        List<RuleSet> ruleSetList = ruleSetDao.findAll(spec);
        for (RuleSet rules:ruleSetList) {
            List<Rule> ruleList = rules.getRuleList().stream()
                    .filter(rule -> rule.getStatus() != 0)
                    .collect(toList());
            rules.setRuleList(ruleList);
        }
        return ServerResponse.success(ruleSetList);
    }

//    @Override
//    public ServerResponse addRuleToSet(Rule rule, Integer ruleSetId) {
//        RuleSet ruleSet = ruleSetDao.findOne(ruleSetId);
//        rule.setRuleSet(ruleSet);
//        ruleDao.save(rule);
//        return ServerResponse.success("保存到规则集成功");
//    }
//
//    @Override
//    public ServerResponse addRuleToProject(Rule rule, Integer projectId) {
//        Project project = projectDao.findOne(projectId);
//        rule.setProject(project);
//        ruleDao.save(rule);
//        return ServerResponse.success("项目自定义规则成功");
//    }

    @Override
    @Transactional
    public ServerResponse deleteRule(Integer id) {
        Rule rule = ruleDao.getOne(id);
        rule.setStatus(0);
        return ServerResponse.success("删除成功");
    }

    private RuleSet filter(RuleSet ruleSet){
        List<Rule> rules = ruleSet.getRuleList();
        List<Rule> collect = rules.stream().filter(rule -> rule.getStatus() != 0).collect(toList());
        ruleSet.setRuleList(collect);
        return ruleSet;
    }
}
