package com.zjty.inspect.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.inspect.utils.Inspector;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class Report {

    private Language language;
    private String framework;
    private int fileNum;
    private long lineNum;
    /**
     * 取名，后端依赖
     */
    private List<PomDependency> backend;
    /**
     * 取名。前端依赖
     */
    private List<PomDependency> frontend;
    @Transient
    private List<Inspector.Warn> warnList;
    private String compileFilePath;
    public DependenceManagement dependenceManagement;
    @ElementCollection
    public List<String> jarPath;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    public enum DependenceManagement{
        MAVEN,GRADLE,ANT
    }
    public enum Language{
        JAVA,PYTHON,CPP,JSP,ASP,ONLYVIEW,UNKNOW,JAVASCRIPT,GO,VUE
    }
}
