package com.zjty.inspect.service.impl;

import com.alibaba.fastjson.JSON;
import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.entity.PomDependency;
import com.zjty.inspect.entity.Report;
import com.zjty.inspect.entity.Rule;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.utils.Inspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

@Service
public class InspectServiceImpl implements InspectService {

    @Transactional
    @Override
    public Report inspect(InspectParameter inspectParameter) {

        Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
        suffixLanguageMapping.put("java", Report.Language.JAVA);
        suffixLanguageMapping.put("vue", Report.Language.VUE);
        suffixLanguageMapping.put("cpp", Report.Language.CPP);
        suffixLanguageMapping.put("py", Report.Language.PYTHON);
        suffixLanguageMapping.put("jsp", Report.Language.JSP);
        suffixLanguageMapping.put("html", Report.Language.ONLYVIEW);
        suffixLanguageMapping.put("js", Report.Language.JAVASCRIPT);
        suffixLanguageMapping.put("go", Report.Language.GO);
        List<Rule> ruleList = inspectParameter.getRuleList();
        //com.mysql.cj.jdbc.Driver//com.mysql.jdbc.Driver
        ruleList.add(new Rule("com.mysql.cj.jdbc.Driver", "建议修改为postgresql数据库驱动"));
        ruleList.add(new Rule("com.mysql.jdbc.Driver", "建议修改为postgresql数据库驱动"));
        //net.sourceforge.jtds.jdbc.Driver//sqlserver
        ruleList.add(new Rule("net.sourceforge.jtds.jdbc.Driver", "建议修改为postgresql数据库驱动"));
        //COM.ibm.db2.jdbc.app.DB2Driver//com.ibm.db2.jcc.DB2Driver//COM.ibm.db2.jdbc.net.DB2Driver//com.ibm.db2.jcc.DB2Driver
        ruleList.add(new Rule("DB2Driver", "建议修改为postgresql数据库驱动"));
        //oracle.jdbc.OracleDriver//oracle.jdbc.driver.OracleDriver
        ruleList.add(new Rule("OracleDriver", "建议修改为postgresql数据库驱动"));

        ruleList.add(new Rule("mysql-connector-java", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("com.microsoft.sqlserver", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("com.oracle", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("org.mariadb.jdbc", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("com.sap.cloud.db.jdbc", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("com.ibm.informix", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("org.firebirdsql.jdbc", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("org.hsqldb", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("com.h2database", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("org.apache.derby", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("org.mongodb", "建议修改为postgresql依赖声明"));
        ruleList.add(new Rule("package.json", "需要nodejs环境"));
        ruleList.add(new Rule("public native", "这里用到了JNI"));
        ruleList.add(new Rule("<packaging>jar</packaging>", "建议修改打包方式为war包并排除掉springboot内置的tomcat,以部署到国产化中间件上"));
        ruleList.add(new Rule("WebOffice", "这里用到了weboffice文档展示编辑插件"));
        ruleList.add(new Rule("webOffice", "这里用到了weboffice文档展示编辑插件"));
        ruleList.add(new Rule("weboffice", "这里用到了weboffice文档展示编辑插件"));
        ruleList.add(new Rule("Weboffice", "这里用到了weboffice文档展示编辑插件"));
        ruleList.add(new Rule("pdfobject.min.js", "这里用到了pdf文档展示插件"));
        ruleList.add(new Rule("pdfobject.js", "这里用到了pdf文档展示插件"));
        ruleList.add(new Rule(".swf", "这里用到了flash流媒体播放插件"));

        String path = inspectParameter.getPath();
        //调用下载服务下载源代码

        Report report = notList(path, suffixLanguageMapping, ruleList);

        return report;
    }
    public void listfile(String path,Map<String, Report.Language> suffixLanguageMapping,List<Rule> ruleList){
        Path path1 = Paths.get(path);
        File file = path1.toFile();
        File[] files = file.listFiles();
        System.out.println(file.isDirectory());
        for (File file1 : files) {
            Report report = new Inspector(file1.getPath(), suffixLanguageMapping, ruleList).inspect();

            File file2 = new File(file1.getPath() + "/评估报告" + file1.getName() + ".txt");

            try {
                FileWriter writer = new FileWriter(file2);
                writer.write("系统名称：" + file1.getName() + "\n");
                writer.write("评估时间：" + new Date() + "\n\n");
                writer.write("语言：" + report.getLanguage() + "\t");
                writer.write("依赖管理工具：" + report.getDependenceManagement() + "\t");
                writer.write("架构：" + report.getFramework() + "\n");
                writer.write("文件数量：" + report.getFileNum() + "\t");
                writer.write("代码行数：" + report.getLineNum() + "\n\n");

                writer.write("后端依赖列表：\n");
                for (PomDependency dependency : report.getBackend()) {
                    writer.write("" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getGradle() + "\n");
                }
                writer.write("\n前端依赖列表：\n");
                for (PomDependency dependency : report.getFrontend()) {
                    writer.write("" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":");
                }

                int j = 1;
                for (Inspector.Warn warn : report.getWarnList()) {
                    writer.write(j++ + "、所在文件：" + warn.getPath() + " 行数:" + warn.getLine() + "行 关键字:" + warn.getKeyWord() + "\n"
                            + "建议：" + warn.getSuggest());
                }
                writer.close();
            } catch (IOException e) {

            }
        }
    }
    public Report notList(String path,Map<String, Report.Language> suffixLanguageMapping,List<Rule> ruleList){
        Path path1 = Paths.get(path);
        File file = path1.toFile();
        File file2 = new File(file.getPath() + "/评估报告" + file.getName() + ".txt");
        if (file2.exists()){
            file2.delete();

        }
        Report report = new Inspector(file.getPath(), suffixLanguageMapping, ruleList).inspect();

        try {
            FileWriter writer = new FileWriter(file2);
            writer.write("系统名称：" + file.getName() + "\n");
            writer.write("评估时间：" + new Date() + "\n\n");
            writer.write("语言：" + report.getLanguage() + "\t");
            writer.write("依赖管理工具：" + report.getDependenceManagement() + "\t");
            writer.write("架构：" + report.getFramework() + "\n");
            writer.write("文件数量：" + report.getFileNum() + "\t");
            writer.write("代码行数：" + report.getLineNum() + "\n\n");

            writer.write("后端依赖列表：\n");
            for (PomDependency dependency : report.getBackend()) {
                writer.write("" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getGradle() + "\n");
            }
            writer.write("\n前端依赖列表：\n");
            for (PomDependency dependency : report.getFrontend()) {
                writer.write("" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":");
            }

            int j = 1;
            for (Inspector.Warn warn : report.getWarnList()) {
                writer.write(j++ + "、所在文件：" + warn.getPath() + " 行数:" + warn.getLine() + "行 关键字:" + warn.getKeyWord() + "\n"
                        + "建议：" + warn.getSuggest());
            }
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return report;
    }
}
