package com.zjty.inspect.utils;

import com.alibaba.fastjson.JSONObject;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.entity.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

public class AnalysisFile {
    public static ProjectPom analysisPom(Path pomPath){
        ProjectPom projectPom = new ProjectPom();
        List<PomDependency> dependencies = new ArrayList<>();
        Document document = null;
        try {
            document = DocumentHelper.parseText(new String(Files.readAllBytes(pomPath)));
        } catch (DocumentException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        if(rootElement.element("properties")!=null){
            Element dependencies1 = rootElement.element("properties");
            for(Element element:dependencies1.elements()){
                Properties properties = new Properties();
                String name = element.getName();
                String stringValue = element.getStringValue();
                properties.setValue(stringValue);
                properties.setName(name);
                projectPom.getProperties().add(properties);
            }
        }
        projectPom.setModelVersion(rootElement.elementText("modelVersion"));
        projectPom.setGroupId(rootElement.elementText("groupId"));
        projectPom.setArtifactId(rootElement.elementText("artifactId"));
        projectPom.setPackaging(rootElement.elementText("packing"));
        projectPom.setVersion(rootElement.elementText("version"));
        if(rootElement.elementText("version")!=null){
            projectPom.setVersion(rootElement.elementText("version"));
        }
        projectPom.setName(rootElement.elementText("name"));
        projectPom.setDescription(rootElement.elementText("description"));

        if(rootElement.element("dependencies")!=null){
            Element dependencies1 = rootElement.element("dependencies");
            List<Element> dependency = dependencies1.elements("dependency");
            for(Element element:dependency){
                PomDependency pomDependency = new PomDependency();
                pomDependency.setGroupId(element.elementText("groupId"));
                pomDependency.setArtifactId(element.elementText("artifactId"));
                if(element.elementText("version")!=null){
                    pomDependency.setVersion(element.elementText("version"));
                }
                dependencies.add(pomDependency);
            }
        }
        if(rootElement.elements("parent")!=null){
            List<Element> parent = rootElement.elements("parent");
            for(Element p:parent){
                PomDependency pomDependency = new PomDependency();
                pomDependency.setGroupId(p.elementText("groupId"));
                pomDependency.setArtifactId(p.elementText("artifactId"));
                if(p.elementText("version")!=null){
                    pomDependency.setVersion(p.elementText("version"));
                }
                dependencies.add(pomDependency);
            }
        }
        if(rootElement.element("dependencyManagement")!=null){
            Element dependencies1 = rootElement.element("dependencyManagement");
            Element dependencies2 = dependencies1.element("dependencies");
            List<Element> dependency = dependencies2.elements("dependency");
            for(Element element:dependency){
                PomDependency pomDependency = new PomDependency();
                pomDependency.setGroupId(element.elementText("groupId"));
                pomDependency.setArtifactId(element.elementText("artifactId"));
                if(element.elementText("version")!=null){
                    pomDependency.setVersion(element.elementText("version"));
                }
                dependencies.add(pomDependency);
            }
        }
        projectPom.setDependencies(dependencies);
        return projectPom;
    }
    public static List<PomDependency> analysisGradle(Path pomPath) {
        List<String> strings = null;
        try {
            strings = Files.readAllLines(pomPath);
        } catch (IOException e) {
            e.printStackTrace();
        }
        List<PomDependency> dependencies = new ArrayList<>();
        for (String string : strings) {
            if(string.indexOf("compile")>0){
                PomDependency pomDependency = new PomDependency();
                int compile = string.indexOf("compile");
                int i = compile + 8;
                String substring = string.substring(i);
                pomDependency.setGradle(substring);
                dependencies.add(pomDependency);
            }
        }
        return dependencies;
    }

    public static void main(String[] args) {
        Path path = Paths.get("/Users/mcj/IdeaProjects/inspect/tree.txt");
        int is=0;
        boolean b1 = path.toString().endsWith("");


        HashMap<Integer, DepTree> map = new HashMap<>();
        int one = 1;
        DepTree depTree = new DepTree();
        try {
            List<String> strings = Files.readAllLines(path);
            String s1 = strings.get(7);
            String s2 = s1.replaceAll("\\[INFO] ", "");
            depTree.setDepName(s2);
            map.put(1,depTree);
            int now = 0;
            for (int i = 8; i <= strings.size()-7; i++) {
                DepTree depTree1 = new DepTree();
                String s = strings.get(i).replaceAll("\\[INFO] ", "");
                int i1 = s.indexOf("-");
                if(i1==one){
                    depTree1.setDepName(s);
                    depTree.getDepTreeList().add(depTree1);
                }else{
                    if(i1>now){
                        depTree1.setDepName(s);
                        map.get(i1).getDepTreeList().add(depTree1);
                    }else{
                        depTree1.setDepName(s);
                        map.get(i1).getDepTreeList().add(depTree1);
                    }
                }
                map.put(i1+3,depTree1);
                now = i1;
            }
            DepTreeAndReport depTreeAndReport = new DepTreeAndReport();
            depTreeAndReport.setId("报告id");
            depTreeAndReport.setDepTree(depTree);
            Object o = JSONObject.toJSON(depTreeAndReport);
            System.out.println(o);
        } catch (IOException e) {
            e.printStackTrace();
        }


        String a = "AAbaaa";
        String b = "cccccaaB";
        boolean aaB = a.equalsIgnoreCase("aaB");
        int aaB1 = b.indexOf("aaB");
        int i = AnalysisFile.EditDistance(a, b);
        System.out.println(i);
    }

    public static int EditDistance(String source, String target) {
        char[] sources = source.toCharArray();
        char[] targets = target.toCharArray();
        int sourceLen = sources.length;
        int targetLen = targets.length;
        int[][] d = new int[sourceLen + 1][targetLen + 1];
        for (int i = 0; i <= sourceLen; i++) {
            d[i][0] = i;
        }
        for (int i = 0; i <= targetLen; i++) {
            d[0][i] = i;
        }

        for (int i = 1; i <= sourceLen; i++) {
            for (int j = 1; j <= targetLen; j++) {
                if (sources[i - 1] == targets[j - 1]) {
                    d[i][j] = d[i - 1][j - 1];
                } else {
                    //插入
                    int insert = d[i][j - 1] + 1;
                    //删除
                    int delete = d[i - 1][j] + 1;
                    //替换
                    int replace = d[i - 1][j - 1] + 1;
                    d[i][j] = Math.min(insert, delete) > Math.min(delete, replace) ? Math.min(delete, replace) :
                            Math.min(insert, delete);
                }
            }
        }
        return d[sourceLen][targetLen];
    }


}
