package com.zjty.inspect.entity;

import com.zjty.inspect.enums.DatabaseType;
import com.zjty.inspect.task.task;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * <h4>Description : 数据库相关</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 18:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "数据库相关")
public class Database {

    /**
     * 数据库类型 枚举
     */
    @ApiModelProperty(value = "数据库类型")
    private List<DatabaseType> databaseType;

    /**
     * 其他
     */
    @ApiModelProperty(value = "其他")
    private String otherType;

    /**
     * 视图 int 1：是 2：否
     */
    @ApiModelProperty(value = "视图 int 1：是 2：否",example = "1")
    private Integer view = -1;
    /**
     * 存储过程 1：是 2：否
     */
    @ApiModelProperty(value = "存储过程 1：是 2：否",example = "1")
    private Integer storage = -1;

    /**
     * 函数 1：是 2：否
     */
    @ApiModelProperty(value = "函数 1：是 2：否",example = "1")
    private Integer function = -1;

    /**
     * Dblink 1：是 2：否
     */
    @ApiModelProperty(value = "Dblink 1：是 2：否",example = "1")
    private Integer dbLink = -1;

    /**
     * 定时任务 1：是 2：否
     */
    @ApiModelProperty(value = "定时任务 1：是 2：否",example = "1")
    private Integer timeTask = -1;

    /**
     * 序列 1：是 2：否
     */
    @ApiModelProperty(value = "序列 1：是 2：否",example = "1")
    private Integer sequence = -1;

    /**
     * 触发器 1：是 2：否
     */
    @ApiModelProperty(value = "触发器 1：是 2：否",example = "1")
    private Integer trigger = -1;

    /*
    更多内容
     */

    /**
     * 容灾 （1：否 2：主备 3：分布式）
     */
    @ApiModelProperty(value = "容灾 （1：否 2：主备 3：分布式）",example = "1")
    private Integer disasterTolerance = -1;

    /**
     * 安全 1：是 2：否
     */
    @ApiModelProperty(value = "安全 1：是 2：否",example = "1")
    private Integer safe = -1;

    /**
     * 读写分离 1：是 2：否
     */
    @ApiModelProperty(value = "读写分离 1：是 2：否",example = "1")
    private Integer separate = -1;

    /**
     * 更高性能 1：是 2：否
     */
    @ApiModelProperty(value = "更高性能 1：是 2：否",example = "1")
    private Integer performance = -1;

    /**
     * 其他内容
     */
    @ApiModelProperty(value = "其他内容")
    private String otherContent;
}
