package com.zjty.inspect.entity;

import com.zjty.inspect.enums.OperateSystem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <h4>Description : 原系统部署架构</h4>
 *
 * @author : czq
 * @Date : 2020-03-05 17:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "原系统部署架构")
public class Details {
    /**
     * 部署情况  1、本地 2：政务云
     */
    @ApiModelProperty(value = "部署情况  1、本地 2：政务云",example = "1")
    private Integer deploy = -1;

    /**
     * 操作系统 枚举
     */
    @ApiModelProperty(value = "操作系统 枚举")
    private OperateSystem operateSystem = OperateSystem.NONE;

    /**
     * 台数
     */
    @ApiModelProperty(value = "台数")
    private Integer num;
    /**
     * CPU核数
     */
    @ApiModelProperty(value = "CPU核数")
    private Integer cpuNum;
    /**
     * 单核主频
     */
    @ApiModelProperty(value = "单核主频")
    private String ghz;
    /**
     * 服务器总空间
     */
    @ApiModelProperty(value = "服务器总空间")
    private double space;
    /**
     * 其他
     */
    @ApiModelProperty(value = "其他")
    private String other;

    /**
     * 版本
     */
    @ApiModelProperty(value = "版本")
    private String edition;
}
