package com.zjty.inspect.entity;

import com.zjty.inspect.enums.MiddlewareEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * <h4>Description : 中间件/API</h4>
 *
 * @author : czq
 * @Date : 2020-03-05 17:39
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "中间件")
public class Middleware {


    /**
     * 原文件情况 枚举
     */
    @ApiModelProperty(value = "原文件情况")
    private List<MiddlewareEnum> middlewareEnums;
    /**
     * 原应用第三方api
     */
    @ApiModelProperty(value = "原应用第三方api")
    private List<OtherApi> otherApis;
    /**
     * 其他中间件
     */
    @ApiModelProperty(value = "其他中间件")
    private String otherMiddleware;
    /**
    * 额外微服务
    */
    @ApiModelProperty(value = "额外微服务")
    private List<BaseDes> microServices;
    /*
    更多需求
     */

    /**
     *Web集群 1:是 2：否
     */
    @ApiModelProperty(value = "Web集群 1:是 2：否",example = "1")
    private Integer web = -1;

    /**
     * Jndi集群 1:是 2：否
     */
    @ApiModelProperty(value = "Jndi集群 1:是 2：否",example = "1")
    private Integer jndi = -1;

    /**
     * Jms集群 1:是 2：否
     */
    @ApiModelProperty(value = "Jms集群 1:是 2：否",example = "1")
    private Integer jms = -1;

    /**
     * 消息路由 1:是 2：否
     */
    @ApiModelProperty(value = "消息路由 1:是 2：否",example = "1")
    private Integer route = -1;
}
