package com.zjty.inspect.enums;

import com.zjty.inspect.entity.FontTechnologyEnum;
import com.zjty.inspect.entity.OpgaEnum;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * <h4>Description : inspect</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 17:53
 */
@Getter
public enum MiddlewareEnum {
    NONE(-1,"无"),
     IIS(0,"IIS"),
    TOMCAT(1,"Tomcat"),
    NGNIX(2,"Ngnix"),
    WEBSPHERE(3,"Websphere"),
    WEBLOGIC(4,"Weblogic"),
    JBOSS(5,"JBOSS"),
    JONAS(6,"JOnAS"),
    HADOOP(7,"Hadoop"),
    KAFKA(8,"Kafka"),
    SPARK(9,"Spark"),
    LVS(10,"LVS"),
    LHA(11,"LHA"),
    GERONIMO(12,"Geronimo"),
    JINDIE(13,"金蝶"),
    DONGFANGTONG(14,"东方通"),
    OTHER(15,"其他：请在备注中填写,如需填写多个,请以逗号分隔");

     private Integer code;
     private String name;
    private static Map<String, MiddlewareEnum> middlewareEnumMap=new HashMap<>();
    static {
        for (MiddlewareEnum middlewareEnum : MiddlewareEnum.values()) {
            middlewareEnumMap.put(middlewareEnum.getName(),middlewareEnum);
        }
    }
    MiddlewareEnum() {
    }

    MiddlewareEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static MiddlewareEnum getByName(String name){
        MiddlewareEnum middlewareEnum = middlewareEnumMap.get(name);
        if(middlewareEnum == null){
            return null;
        }
        return middlewareEnum;
    }
}
