package com.zjty.inspect.enums;

import com.zjty.inspect.entity.MainLanguageEnum;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
@Getter
public enum  OtherApiEnum {
    无(1,"无"),
    JNDI(1,"JNDI"),
    ML(1,"其他命名与目录类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    JMS(1,"JMS"),
    RestFul(1,"RestFul"),
    XX(1,"其他消息类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    AMQP(1,"AMQP"),
    KAFKA(1,"Kafka API"),
    MQTT(1,"MQTT"),
    ROUTE(1,"其他消息路由类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    ES(1,"ES"),
    YQ(1,"其他搜索引擎类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    LOGSTASH(1,"Logstash"),
    LOG(1,"其他分析日志类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    KIBANA(1,"Kibana"),
    FXKS(1,"其他分析可视化类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    REDIS(1,"Redis"),
    JIQ(1,"其他集群类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    ARCGIS(1,"ARCGIS"),
    GIS(1,"其他GIS类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    EDIT(1,"在线编辑API：请在备注中填写,如需填写多个,请以逗号分隔"),
    TUBIAO(1,"统计图表类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    BF(1,"播放类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    YJ(1,"硬件驱动类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    OCR(1,"OCR识别类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    JIAMI(1,"加密类API：请在备注中填写,如需填写多个,请以逗号分隔"),
    OTHER(1,"其他：请在备注中填写,如需填写多个请以逗号分隔");

    private Integer code;
    private String name;
    private static Map<String,OtherApiEnum> otherApiEnumMap=new HashMap<>();
    static {
        for (OtherApiEnum otherApiEnum : OtherApiEnum.values()) {
            otherApiEnumMap.put(otherApiEnum.getName(),otherApiEnum);
        }
    }
    OtherApiEnum() {
    }

    OtherApiEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static OtherApiEnum getByName(String name){
        OtherApiEnum otherApiEnum = otherApiEnumMap.get(name);
        if(otherApiEnum == null){
            return null;
        }
        return otherApiEnum;
    }
}
