package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.EvaluationDao;
import com.zjty.inspect.entity.Evaluation;
import com.zjty.inspect.entity.Rule;
import com.zjty.inspect.service.EvaluationService;
import com.zjty.inspect.utils.TimeUtil;
import com.zjty.inspect.utils.UUIDUtil;
import io.netty.util.internal.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service
@Transactional(rollbackFor = Exception.class)
public class EvaluationServiceImpl implements EvaluationService {
    @Autowired
    private EvaluationDao evaluationDao;

    @Override
    public Evaluation save(Evaluation evaluation) {
        if (StringUtils.isEmpty(evaluation.getInEva())) {
            return null;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getOutEva())) {
            return null;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getUsername())) {
            return null;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getProjectName())) {
            return null;
        }
        String uuid = UUIDUtil.getUUID();
        evaluation.setId(uuid);
        return evaluationDao.save(evaluation);
    }

    @Override
    public void update(Evaluation evaluation) {
        Evaluation evaluation1 = evaluationDao.findByUsernameAndIdNot(evaluation.getUsername(), evaluation.getId());
        if (evaluation1 != null) {
            return;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getInEva())) {
            return;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getOutEva())) {
            return;
        }
        evaluationDao.save(evaluation);

    }

    @Override
    public void delete(String id) {
        evaluationDao.deleteById(id);
    }

    @Override
    public Page<Evaluation> findSearch(Map searchMap, int page, int size) {
        Specification<Evaluation> specification = createSpecification(searchMap);
        PageRequest pageRequest = PageRequest.of(page - 1, size, Sort.Direction.DESC, "createDate");
        return evaluationDao.findAll(specification, pageRequest);
    }

    @Override
    public Evaluation findById(String id) {
        Optional<Evaluation> evaluation = evaluationDao.findById(id);
        if (evaluation.isPresent()) {
            return evaluation.get();
        }
        return null;
    }

    @Override
    public Evaluation findByName(String name) {
        Evaluation evaluation = evaluationDao.findByUsernameAndMaxCreateDate(name);
        if (evaluation != null) {
            return evaluation;
        }
        return null;
    }


    /**
     * 动态条件构建
     *
     * @param searchMap
     * @return
     */
    private Specification<Evaluation> createSpecification(Map searchMap) {

        return new Specification<Evaluation>() {

            @Override
            public Predicate toPredicate(Root<Evaluation> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                List<Predicate> predicateList = new ArrayList<Predicate>();
                if (searchMap.get("username") != null && !"".equals(searchMap.get("username"))) {
                    predicateList.add(cb.like(root.get("username").as(String.class), "%" + (String) searchMap.get("username") + "%"));
                }
                if (searchMap.get("projectName") != null && !"".equals(searchMap.get("projectName"))) {
                    predicateList.add(cb.like(root.get("projectName").as(String.class), "%" + (String) searchMap.get("projectName") + "%"));
                }

                return cb.and(predicateList.toArray(new Predicate[predicateList.size()]));

            }
        };

    }
}
