package com.zjty.inspect.utils;

import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.CompatibleBrowser;
import com.zjty.inspect.enums.DatabaseType;
import com.zjty.inspect.enums.MiddlewareEnum;
import com.zjty.inspect.enums.OperateSystem;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author Mcj
 * @date 2019-07-17 16:52
 */

public class ExcelUtil {

    private static String xlsx = "xlsx";
    private static String xls = "xls";

    public static Reform parseExcel(MultipartFile f1) {
        try {
            InputStream fileInputStream = f1.getInputStream();
            String[] split = Objects.requireNonNull(f1.getOriginalFilename()).split("\\.");
            if (xlsx.equals(split[1])) {
                XSSFWorkbook xwb = new XSSFWorkbook(fileInputStream);
                //3、得到Excel工作表对象
                XSSFSheet sheetAt = xwb.getSheetAt(0);
                Reform reform = getReform(sheetAt);

                return reform;

            } else if (xls.equals(split[1])) {
                HSSFWorkbook xwb = new HSSFWorkbook(fileInputStream);
                //3、得到Excel工作表对象
                HSSFSheet sheetAt = xwb.getSheetAt(0);
                Reform reform = getReform(sheetAt);
                return reform;
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
        return new Reform();
    }

    private static String getExcelCell(int rowNum, int cellNum, Sheet sheetAt) {
        Row row = sheetAt.getRow(rowNum);
        Cell cell = row.getCell(cellNum);
        return cell.toString();
    }

    private static Reform getReform(Sheet sheetAt) {
        Reform reform = new Reform();
        //单位名称
        String unitName = getExcelCell(2, 2, sheetAt);
        reform.setUnitName(unitName);

        //系统名称
        String projectName = getExcelCell(3, 2, sheetAt);
        reform.setProjectName(projectName);
        String cost = getExcelCell(4, 2, sheetAt);
        double i1 = returnDouble(cost);
        reform.setCost((int) i1);
        String cycle = getExcelCell(5, 2, sheetAt);
        String s = cycle.replaceAll("年", "");

        reform.setCycle(returnNum(s) *12 );

        String time = getExcelCell(6, 2, sheetAt);
        if (!"".equals(time)) {
            if ("10年以上".equals(time)) {
                reform.setTime(11);
            } else {
                String year = time.replaceAll("年", "");
                Integer newYear = Integer.valueOf(year);
                reform.setTime(newYear);
            }
        }
        String address = getExcelCell(7, 2, sheetAt);
        reform.setAddress(yesOrNo(address));
        String phone = getExcelCell(7, 4, sheetAt);
        String[] split = phone.split("\n");
        if (split.length > 0) {
            reform.setLocalContact(phone);
        }

        String secret = getExcelCell(8, 2, sheetAt);
        reform.setSecret(yesOrNo(secret));

        String gradeProtection = getExcelCell(9, 2, sheetAt);
        reform.setGradeProtection(yesOrNo(gradeProtection));

        String construction = getExcelCell(10, 2, sheetAt);
        switch (construction) {
            case "B/S":
            case "C/S":
                reform.setFramework(2);
                break;
            case "单机运行":
                reform.setFramework(0);
                break;
            case "分布式":
                reform.setFramework(4);
                break;
        }

        String disaster = getExcelCell(11, 2, sheetAt);
        reform.setDisasterTolerance(yesOrNo(disaster));

        String type = getExcelCell(12, 2, sheetAt);
        ArrayList<Integer> applicationType = new ArrayList<>();

        switch (type) {
            case "办公OA应用类":
                applicationType.add(1);
                break;
            case "门户、信息发布、综合入口服务类":
                applicationType.add(2);
                break;
            case "申报、填报、审批等公共行政服务类":
                applicationType.add(4);
                break;
            case "数据收集、分析、态势感知等大数据应用类":
                applicationType.add(5);
                break;
            case "地图、定位等GIS服务类":
                applicationType.add(6);
                break;
            case "视频、图形等流媒体应用类":
                applicationType.add(7);
                break;
            case "3D、模型等视觉建模应用类":
                applicationType.add(8);
                break;
        }
        reform.setApplicationType(applicationType);

        String module = getExcelCell(13, 2, sheetAt);
        reform.setModuleNum((int) returnDouble(module));
        String mode = getExcelCell(15, 2, sheetAt);
        if ("终端适配".equals(mode)) {
            reform.setMode(2);
        } else {
            reform.setMode(1);
        }
        DevelopLanguageSystem developLanguageSystem = new DevelopLanguageSystem();
        List<BaseDes> devFrameworks = new ArrayList<>();
        for (int i = 17; i < 22; i++) {
            String framework = getExcelCell(i, 2, sheetAt);

            if ("".equals(framework)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes devFramework = new BaseDes();
            Integer code = FrameWorkEnum.getByName(framework).getCode();
            devFramework.setCode(code);
            devFramework.setVersion(version);
            devFramework.setDes(remark);
            devFrameworks.add(devFramework);
        }
        developLanguageSystem.setDevFrameworks(devFrameworks);


        List<BaseDes> csDevTechnologies = new ArrayList<>();
        for (int i = 22; i < 27; i++) {
            String framework = getExcelCell(i, 2, sheetAt);
            if ("".equals(framework)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes csDevTechnology = new BaseDes();
            CSTechnologyEnum byName = CSTechnologyEnum.getByName(framework);
            csDevTechnology.setCode(byName.getCode());
            csDevTechnology.setName(framework);
            csDevTechnology.setDes(remark);
            csDevTechnology.setVersion(version);
            csDevTechnologies.add(csDevTechnology);
        }
        developLanguageSystem.setCsDevTechnologies(csDevTechnologies);

        List<BaseDes> fontDevTechnologies = new ArrayList<>();
        for (int i = 28; i < 33; i++) {
            String framework = getExcelCell(i, 2, sheetAt);
            if ("".equals(framework)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes fontDevTechnology = new BaseDes();
            fontDevTechnology.setDes(remark);
            fontDevTechnology.setVersion(version);
            FontTechnologyEnum byName = FontTechnologyEnum.getByName(framework);
            fontDevTechnology.setCode(byName.getCode());
            fontDevTechnology.setName(byName.getName());
            fontDevTechnologies.add(fontDevTechnology);
        }
        developLanguageSystem.setFontDevTechnologies(fontDevTechnologies);

        List<BaseDes> opGAS = new ArrayList<>();
        for (int i = 34; i < 39; i++) {
            String framework = getExcelCell(i, 2, sheetAt);
            if ("".equals(framework)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes opGA = new BaseDes();
            OpgaEnum byName = OpgaEnum.getByName(framework);
            opGA.setName(framework);
            opGA.setCode(byName.getCode());
            opGA.setVersion(version);
            opGA.setDes(remark);
            opGAS.add(opGA);
        }
        developLanguageSystem.setOpGAs(opGAS);

        String language = getExcelCell(39, 2, sheetAt);
        developLanguageSystem.setCode(MainLanguageEnum.getByName(language).getCode());
        developLanguageSystem.setName(MainLanguageEnum.getByName(language).getName());

        ArrayList<BaseDes> devLanguages = new ArrayList<>();
        for (int i = 40; i < 45; i++) {
            String lan = getExcelCell(i, 2, sheetAt);
            if ("".equals(lan)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes devLanguage = new BaseDes();
            LanguageEnum byName = LanguageEnum.getByName(lan);
            devLanguage.setName(byName.getName());
            devLanguage.setCode(byName.getCode());
            devLanguage.setVersion(version);
            devLanguage.setDes(remark);
            devLanguages.add(devLanguage);
        }
        developLanguageSystem.setDevLanguages(devLanguages);

        /**
         * 中间件/API
         */
        Middleware middleware = new Middleware();
        List<MiddlewareEnum> middlewareEnums = new ArrayList<>();
        for (int i = 46; i < 51; i++) {
            String middleware1 = getExcelCell(i, 2, sheetAt);
            MiddlewareEnum byName = MiddlewareEnum.getByName(middleware1);
            middlewareEnums.add(byName);
        }
        middleware.setMiddlewareEnums(middlewareEnums);
        reform.setMiddleware(middleware);

        ArrayList<OtherApi> otherApis = new ArrayList<>();
        for (int i = 51; i < 61; i++) {
            String api = getExcelCell(i, 2, sheetAt);
            if ("".equals(api)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            OtherApi otherApi = new OtherApi();
            otherApi.setApiName(api);
            otherApi.setDes(remark);
            otherApi.setVersion(version);
            otherApis.add(otherApi);
        }
        middleware.setOtherApis(otherApis);

        List<BaseDes> microServices = new ArrayList<>();
        for (int i = 62; i < 72; i++) {
            String name = getExcelCell(i, 2, sheetAt);
            if ("".equals(name)) {
                continue;
            }
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            BaseDes microService = new BaseDes();
            MicroServiceEnum byName = MicroServiceEnum.getByName(name);
            microService.setCode(byName.getCode());
            microService.setName(byName.getName());
            microService.setDes(remark);
            microService.setVersion(version);
            microServices.add(microService);
        }
        middleware.setMicroServices(microServices);


        //数据库相关
        Database database1 = new Database();
        ArrayList<DatabaseType> databaseTypes = new ArrayList<>();
        for (int i = 74; i < 77; i++) {
            String database = getExcelCell(i, 2, sheetAt);
            DatabaseType byName = DatabaseType.getByName(database);
            databaseTypes.add(byName);
        }
        database1.setDatabaseType(databaseTypes);

        String tableNum = getExcelCell(77, 2, sheetAt);
        if ("".equals(tableNum)) {
            reform.setTableNum(0);
        } else {
            reform.setTableNum(Integer.valueOf(tableNum));
        }

        String sp = getExcelCell(81, 2, sheetAt);
        database1.setSeparate(yesOrNo(sp));
        String dblink = getExcelCell(82, 2, sheetAt);
        database1.setDbLink(yesOrNo(dblink));
        String view = getExcelCell(83, 2, sheetAt);
        database1.setView(yesOrNo(view));
        String storage = getExcelCell(84, 2, sheetAt);
        database1.setStorage(yesOrNo(storage));
        String function = getExcelCell(85, 2, sheetAt);
        database1.setFunction(yesOrNo(function));
        String timeTask = getExcelCell(86, 2, sheetAt);
        database1.setTimeTask(yesOrNo(timeTask));
        String sequence = getExcelCell(87, 2, sheetAt);
        database1.setSequence(yesOrNo(sequence));
        String trigger = getExcelCell(88, 2, sheetAt);
        database1.setTrigger(yesOrNo(trigger));
        String disasterTolerance = getExcelCell(89, 2, sheetAt);
        database1.setDisasterTolerance(yesOrNo(disasterTolerance));
        String safe = getExcelCell(90, 2, sheetAt);
        database1.setSafe(yesOrNo(safe));
        String performance = getExcelCell(91, 2, sheetAt);
        if (!"无".equals(performance)) {
            database1.setPerformance(1);
        }
        reform.setDatabase(database1);

        Browser browser = new Browser();
        List<CompatibleBrowser> compatibleBrowsers = new ArrayList<>();
        for (int i = 93; i <= 97; i++) {
            String brows = getExcelCell(i, 2, sheetAt);
            compatibleBrowsers.add(CompatibleBrowser.getByName(brows));
        }
        browser.setCompatibleBrowsers(compatibleBrowsers);

        ArrayList<BrowserPlug> browserPlugs = new ArrayList<>();

        for (int i = 98; i <= 108; i++) {
            String plugin = getExcelCell(i, 2, sheetAt);
            BrowserPlug browserPlug = new BrowserPlug();
            String version = getExcelCell(i, 3, sheetAt);
            String remark = getExcelCell(i, 4, sheetAt);
            browserPlug.setVersion(version);
            browserPlug.setDes(remark);

            BrowserPlugEnum byName = BrowserPlugEnum.getByName(plugin);
            browserPlug.setBrowserPlugEnum(byName);
            switch (plugin) {
                case "在线文本编辑类：请在备注中填写插件名和版本":
                    break;
                case "打印调用":
                case "扫描调用":
                    browser.setPeripheral(1);
                    break;
                case "在线3D建模、渲染、展现：请在备注中填写插件名和版本":
                    browser.setThreeD(1);
                    break;
                case "在线视频播放类：请在备注中填写插件名和版本":
                    browser.setMedia(1);
                    break;
                default:
                    browser.setOtherDemand(1);
                    break;
            }
            browserPlugs.add(browserPlug);
        }

        SystemStructure systemStructure = new SystemStructure();
        Details ecsdetails = new Details();
        String ecs = getExcelCell(113, 2, sheetAt);
        if ("本地".equals(ecs)) {
            ecsdetails.setDeploy(1);
        } else if ("政务云".equals(ecs)) {
            ecsdetails.setDeploy(2);
        }

        String ecssys = getExcelCell(113, 4, sheetAt);
        OperateSystem byName = OperateSystem.getByName(ecssys);
        ecsdetails.setOperateSystem(byName);
        String num = getExcelCell(113, 3, sheetAt);
        ecsdetails.setNum(returnNum(num));
        String cpu = getExcelCell(113, 5, sheetAt);
        ecsdetails.setCpuNum(returnNum(cpu));
        String ghz = getExcelCell(113, 6, sheetAt);
        ecsdetails.setGhz(ghz);
        String gb = getExcelCell(113, 7, sheetAt);
        ecsdetails.setSpace(returnNum(cpu));
        String space = getExcelCell(113, 8, sheetAt);
        ecsdetails.setSpace(returnDouble(space));
        systemStructure.setApplication(ecsdetails);

        Details rdsdetails = new Details();
        String rds = getExcelCell(114, 2, sheetAt);

        if ("本地".equals(rds)) {
            rdsdetails.setDeploy(1);
        } else if ("政务云".equals(rds)) {
            rdsdetails.setDeploy(2);
        }
        String rdssys = getExcelCell(114, 4, sheetAt);
        OperateSystem rdsByName = OperateSystem.getByName(rdssys);
        rdsdetails.setOperateSystem(rdsByName);
        String num1 = getExcelCell(113, 3, sheetAt);
        rdsdetails.setNum(returnNum(num1));
        String cpu1 = getExcelCell(113, 5, sheetAt);
        rdsdetails.setCpuNum(returnNum(cpu1));
        String ghz1 = getExcelCell(113, 6, sheetAt);
        rdsdetails.setGhz(ghz1);
        String space1 = getExcelCell(113, 8, sheetAt);
        rdsdetails.setSpace(returnDouble(space1));

        systemStructure.setDatabase(rdsdetails);


        Details nasdetails = new Details();
        String nas = getExcelCell(115, 2, sheetAt);

        if ("本地".equals(nas)) {
            nasdetails.setDeploy(1);
        } else if ("政务云".equals(nas)) {
            nasdetails.setDeploy(2);
        }
        String nassys = getExcelCell(115, 4, sheetAt);
        OperateSystem nasByName = OperateSystem.getByName(nassys);
        nasdetails.setOperateSystem(nasByName);
        String num2 = getExcelCell(113, 3, sheetAt);
        nasdetails.setNum(returnNum(num2));
        String cpu2 = getExcelCell(113, 5, sheetAt);
        nasdetails.setCpuNum(returnNum(cpu2));
        String ghz2 = getExcelCell(113, 6, sheetAt);
        nasdetails.setGhz(ghz2);
        String space2 = getExcelCell(113, 8, sheetAt);
        nasdetails.setSpace(returnDouble(space2));

        systemStructure.setStorage(nasdetails);
        Details slbdetails = new Details();

        String slb = getExcelCell(116, 2, sheetAt);

        if ("本地".equals(slb)) {
            slbdetails.setDeploy(1);
        } else if ("政务云".equals(slb)) {
            slbdetails.setDeploy(2);
        }
        String slbsys = getExcelCell(116, 4, sheetAt);
        OperateSystem slbByName = OperateSystem.getByName(slbsys);
        slbdetails.setOperateSystem(slbByName);

        String num3 = getExcelCell(113, 3, sheetAt);
        ecsdetails.setNum(returnNum(num3));
        String cpu3 = getExcelCell(113, 5, sheetAt);
        ecsdetails.setCpuNum(returnNum(cpu3));
        String ghz3 = getExcelCell(113, 6, sheetAt);
        ecsdetails.setGhz(ghz3);
        String space3 = getExcelCell(113, 8, sheetAt);
        ecsdetails.setSpace(returnDouble(space3));

        systemStructure.setSlb(slbdetails);

        reform.setSystemStructure(systemStructure);

        return reform;
    }

    private static int yesOrNo(String target) {
        if ("是".equals(target)) {
            return 1;
        } else if ("否".equals(target)) {
            return 2;
        } else {
            return -1;
        }
    }

    private static int returnNum(String target) {
        if (!"".equals(target)) {
            return Integer.valueOf(target);
        } else {
            return 0;
        }
    }

    private static double returnDouble(String target) {
        if (!"".equals(target)) {
            return Double.valueOf(target);
        } else {
            return 0;
        }
    }

    public static void main(String[] args) {
        MultipartFile f = null;

    }

}

