package com.zjty.inspect.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * <h4>Description : 评估报告</h4>
 *
 * @author : czq
 *
 * @Date : 2020-03-05 18:16
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AssessmentReport {

    /**
     * 数据的状态
     */
    private Integer code;
    /**
     * 单位名称
     */
    private String orgName;

    /**
     * 系统名称
     */
    private String sysName;

    /**
     * 评估时间
     */
    private Date time = new Date();

    /**
     * 难度系数
     */
    private double difficulty;

    /**
     * 语言
     */
    private Integer language;

    /**
     * 类型预算 1：适配、2：改造
     */
    private Integer type;

    /**
     * 架构
     */
    private Integer framework;

    /**
     * 预算金额 double
     */
    private String budget;

    /**
     * 原系统规模
     */
    private SysScale sysScale = new SysScale();

    /**
     * 关键技术及替换策略建议
     */
    private TechnologyList technologyList = new TechnologyList();

    /**
     * 基础工作量评估
     */
    private Workload workload = new Workload();

    /**
     * 额外依赖申请
     */
    private Apply apply = new Apply();

    /**
     * 适配难度评估
     */
    private DifficultyAssessment difficultyAssessment = new DifficultyAssessment();

    /**
     * 造价估算
     */
    private ManufacturingCost manufacturingCost = new ManufacturingCost();

}
