package com.zjty.inspect.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <h4>Description : 框架难度</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 19:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FrameDifficulty {
    //系统评估、额外信息、综合难度
    /**
     * 系统评估
     */
    private double systemEvaluation = 1.1;

    /**
     * 额外信息
     */
    private double message = 1.1;

    /**
     * 综合难度
     */
    private double difficulty = 1.1;

    /**
     * 工作量
     */
    private double load = 0.0;

    /**
     * 详情 1：混合 2：前后端分离
     */
    private Integer details = 1;

    /**
     * 分布式 int 1：是 2：否
     */
    private Integer distributed = 1;

    /**
     * 负载均衡 int 1：是 2：否
     */
    private Integer loadBalance = 1;

    /**
     * 容灾 int 1：是 2：否
     */
    private Integer disaster = 1;

    /**
     * 其他需求
     */
    private String otherDemand = "***********";
}
