package com.zjty.inspect.enums;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "主语言枚举类")
@Getter
public enum  MainLanguageEnum {
    C(1,"VC/C++/C#"),
    VB(2,"VB"),
    DELPHI(3,"Delphi"),
    PHP(4,"PHP"),
    JAVA(5,"JAVA"),
    PYTHON(6,"Python"),
    GO(7,"Go"),
    RUST(8,"Rust"),
    RUBY(9,"Ruby"),
    PERL(10,"Perl"),
    MATLAB(11,"Matlab"),
    QITA(12,"其他：请在备注中填写,如需填写多个,请以逗号分隔");

    private Integer code;
    private String name;

    MainLanguageEnum() {
    }
    private static Map<String,MainLanguageEnum> mainLanguageEnumMap=new HashMap<>();
    private static Map<Integer,MainLanguageEnum> mainLanguageEnumCodeMap=new HashMap<>();

    static {
        for (MainLanguageEnum mainLanguageEnum : MainLanguageEnum.values()) {
            mainLanguageEnumMap.put(mainLanguageEnum.getName(),mainLanguageEnum);
            mainLanguageEnumCodeMap.put(mainLanguageEnum.getCode(),mainLanguageEnum);
        }
    }
    MainLanguageEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static MainLanguageEnum getByName(String name){
        MainLanguageEnum mainLanguageEnum = mainLanguageEnumMap.get(name);
        return mainLanguageEnum;
    }
    public static MainLanguageEnum getByCode(Integer code){
        MainLanguageEnum mainLanguageEnum = mainLanguageEnumMap.get(code);
        return mainLanguageEnum;
    }
}
