package com.zjty.inspect.task;

import com.zjty.inspect.dao.CoefficientModelDao;
import com.zjty.inspect.dao.RuleDao;
import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.entity.CoefficientModel;
import com.zjty.inspect.entity.Rule;
import com.zjty.inspect.entity.Technology;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.utils.AnalysisFile;
import com.zjty.inspect.utils.UUIDUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author Mcj
 * @date 2020-03-02 14:35
 */

@Component
public class task implements CommandLineRunner {

    @Autowired
    private CoefficientModelDao coefficientModelDao;

    @Autowired
    private RuleDao ruleDao;

    @Autowired
    private TechnologyDao technologyDao;

    @Autowired
    private InspectService inspectService;

    @Autowired
    private AnalysisFile analysisFile;

    @Override
    public void run(String... args) {
        ArrayList<CoefficientModel> coefficientModels = new ArrayList<>();
        //无，弱，强
        CoefficientModel coefficientModel = new CoefficientModel();
        coefficientModel.setScale(1);
        coefficientModel.setId(UUIDUtil.getUUID());
        coefficientModel.setName("安全能力");
        coefficientModel.setMin(1);
        coefficientModel.setMax(3);
        coefficientModel.setBelowCoefficient(0D);
        coefficientModel.setMediumCoefficient(0.1);
        coefficientModel.setTopCoefficient(0.2);

        CoefficientModel coefficientMode2 = new CoefficientModel();
        coefficientMode2.setScale(2);
        coefficientMode2.setId(UUIDUtil.getUUID());
        coefficientMode2.setName("安全能力");
        coefficientMode2.setMin(1);
        coefficientMode2.setMax(3);
        coefficientMode2.setBelowCoefficient(-0.1);
        coefficientMode2.setMediumCoefficient(0D);
        coefficientMode2.setTopCoefficient(0.1);

        CoefficientModel coefficientMode3 = new CoefficientModel();
        coefficientMode3.setScale(3);
        coefficientMode3.setId(UUIDUtil.getUUID());
        coefficientMode3.setName("安全能力");
        coefficientMode3.setMin(1);
        coefficientMode3.setMax(3);
        coefficientMode3.setBelowCoefficient(-0.2);
        coefficientMode3.setMediumCoefficient(-0.1);
        coefficientMode3.setTopCoefficient(0D);

        CoefficientModel coefficientMode4 = new CoefficientModel();
        coefficientMode4.setScale(1);
        coefficientMode4.setId(UUIDUtil.getUUID());
        coefficientMode4.setName("容灾能力");
        coefficientMode4.setMin(1);
        coefficientMode4.setMax(2);
        coefficientMode4.setBelowCoefficient(0D);
        coefficientMode4.setMediumCoefficient(0D);
        coefficientMode4.setTopCoefficient(0.05);

        CoefficientModel coefficientMode5 = new CoefficientModel();
        coefficientMode5.setScale(2);
        coefficientMode5.setId(UUIDUtil.getUUID());
        coefficientMode5.setName("容灾能力");
        coefficientMode5.setMin(1);
        coefficientMode5.setMax(3);
        coefficientMode5.setBelowCoefficient(0.05);
        coefficientMode5.setMediumCoefficient(0D);
        coefficientMode5.setTopCoefficient(0D);

        CoefficientModel coefficientMode6 = new CoefficientModel();
        coefficientMode6.setScale(3);
        coefficientMode6.setId(UUIDUtil.getUUID());
        coefficientMode6.setName("模块");
        coefficientMode6.setMin(4);
        coefficientMode6.setMax(10);
        coefficientMode6.setBelowCoefficient(-0.3);
        coefficientMode6.setMediumCoefficient(0D);
        coefficientMode6.setTopCoefficient(0.3);

        CoefficientModel coefficientMode8 = new CoefficientModel();
        coefficientMode8.setScale(2);
        coefficientMode8.setId(UUIDUtil.getUUID());
        coefficientMode8.setName("模块");
        coefficientMode8.setMin(4);
        coefficientMode8.setMax(10);
        coefficientMode8.setBelowCoefficient(-0.3);
        coefficientMode8.setMediumCoefficient(0D);
        coefficientMode8.setTopCoefficient(0.3);

        CoefficientModel coefficientMode9 = new CoefficientModel();
        coefficientMode9.setScale(1);
        coefficientMode9.setId(UUIDUtil.getUUID());
        coefficientMode9.setName("模块");
        coefficientMode9.setMin(4);
        coefficientMode9.setMax(10);
        coefficientMode9.setBelowCoefficient(-0.3);
        coefficientMode9.setMediumCoefficient(0D);
        coefficientMode9.setTopCoefficient(0.3);

        CoefficientModel coefficientMode7 = new CoefficientModel();
        coefficientMode7.setScale(3);
        coefficientMode7.setId(UUIDUtil.getUUID());
        coefficientMode7.setName("容灾能力");
        coefficientMode7.setMin(1);
        coefficientMode7.setMax(3);
        coefficientMode7.setBelowCoefficient(-0.1);
        coefficientMode7.setMediumCoefficient(0D);
        coefficientMode7.setTopCoefficient(0D);



        coefficientModels.add(coefficientMode6);
        coefficientModels.add(coefficientMode5);
        coefficientModels.add(coefficientMode4);
        coefficientModels.add(coefficientMode3);
        coefficientModels.add(coefficientMode2);
        coefficientModels.add(coefficientModel);
        coefficientModels.add(coefficientMode7);
        coefficientModels.add(coefficientMode8);
        coefficientModels.add(coefficientMode9);
        coefficientModelDao.saveAll(coefficientModels);

        Technology technology = new Technology();
        technology.setTechnologyName("Java依赖");
        technology.setAdvice("国产化支持的依赖");
        technology.setFund(5);
        technology.setId(UUIDUtil.getUUID());
        technology.setSupport(1);

        Technology technology1 = new Technology();
        technology1.setTechnologyName("非国产化依赖");
        technology1.setAdvice("国产化不支持的依赖");
        technology1.setFund(5);
        technology1.setId(UUIDUtil.getUUID());

        Rule rule = new Rule();
        rule.setId(UUIDUtil.getUUID());
        rule.setSuffix("*");
        rule.setTarget("ruleService");
        rule.setTechnologyId(technology.getId());

        Rule rule1 = new Rule();
        rule1.setId(UUIDUtil.getUUID());
        rule1.setSuffix("*");
        rule1.setTarget("mysql-connect");
        rule1.setTechnologyId(technology1.getId());

        technologyDao.save(technology);
        technologyDao.save(technology1);
        ruleDao.save(rule);
        ruleDao.save(rule1);
    }
}
