package com.zjty.inspect.utils;

import org.apache.maven.shared.invoker.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.Collections;

/**
 * @author Mcj
 * @date 2020-03-01 17:11
 */
@Component
public class MavenUtil {

    @Value("${maven.command}")
    private String mavenCommand;
    @Value("${maven.home}")
    private String mavenHome;

    @Value("${maven.treefile}")
    private String treeFile;
    public File genTreeFile(String path){
        InvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(path));
        request.setGoals(Collections.singletonList(mavenCommand+treeFile));

        Invoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        try {
            invoker.execute(request);
        } catch (MavenInvocationException e) {
            e.printStackTrace();
        }
        return new File(treeFile);
    }
}
