package com.zjty.inspect.utils;

import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;

/**
 * @author Mcj
 * @date 2020-02-13 16:01
 */
@Component
public class GitLabUtil {

    public static String downLoadProject(String path,String name) {
        String name1 = LocalDate.now().toString();
        String[] split1 = UUIDUtil.getUUID().split("-");
        //String REMOTE_URL = "https://git.yfzx.zjtys.com.cn:8888/912-system/monitor/adaptation-master.git";
        CloneCommand cloneCommand = Git.cloneRepository();
        cloneCommand.setURI(path);
        File file = new File("./"+name1+"/"+split1[0]+"/"+name);
        file.mkdirs();
        cloneCommand.setDirectory(file);
        try {
            cloneCommand.call();
        } catch (GitAPIException e) {
            e.printStackTrace();
        }
        try {
            return file.getCanonicalPath();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return file.getAbsolutePath();
    }

}



