package com.zjty.inspect.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * <h4>Description : 中间件难度</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 19:30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MiddlewareDifficulty {
    /**
     * 系统评估
     */
    private double systemEvaluation;

    /**
     * 额外信息
     */
    private double message;

    /**
     * 综合难度
     */
    private double difficulty;

    /**
     * 工作量
     */
    private double load;

    /**
     * 依赖详情
     */
    private Integer dependOnNum;

    /*
     *用户额外信息详情
     */
    /**
     *Web集群 1:是 2：否
     */
    private Integer web;

    /**
     * Jndi集群 1:是 2：否
     */
    private Integer jndi;

    /**
     * Jms集群 1:是 2：否
     */
    private Integer jms;

    /**
     * 消息路由 1:是 2：否
     */
    private Integer route;

}
