package com.zjty.inspect.entity;

import com.zjty.inspect.enums.CompatibleBrowser;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * <h4>Description : 前端浏览器相关</h4>
 *
 * @author : czq
 * @Date : 2020-03-05 17:22
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Browser {

    /**
     * 兼容的浏览器
     */
    private List<CompatibleBrowser> compatibleBrowsers;

    /**
     * 插件安装情况int 1：是 2：否
     */
    private Integer PlugInUnit = -1;

    /**
     * 其他兼容的浏览器
     */
    private String otherBrowser;


    /*
    更多需求
     */

    /**
     * 地理信息系统 int 1：是 2：否
     */
    private Integer geography = -1;
    /**
     * 调用外设
     */
    private Integer peripheral = -1;

    /**
     *动画
     */
    private Integer animation = -1;

    /**
     * 3d展示
     */
    private Integer threeD = -1;

    /**
     * 公文显现与编辑
     */
    private Integer document = -1;

    /**
     * 多媒体
     */
    private Integer media = -1;

    /**
     * Flash
     */
    private Integer flash = -1;

    /**
     * 其他
     */
    private Integer otherDemand = -1;
}
