package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * <h4>Description : 应用系统改造替换表单</h4>
 *
 * @author : czq
 * @Date : 2020-03-05 16:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "应用系统改造替换表单")
public class Reform {

    /**
     * admin 是否是管理员
     */
    @ApiModelProperty(value = "是否是管理员",example = "1")
    private Integer admin = -1;
    @ApiModelProperty(value = "权限",example = "1")
    private Integer authority;

    /**
     * username
     */
    private String username;

    /**
     *评估类型1：快速   2：详细
     */
    @ApiModelProperty(value = "评估类型1",example = "1")
    private Integer assessmentType;
    /*
    快速评估部分
     */

    /**
     * 替换方式  int（1：改造 2：适配）
     */
    @ApiModelProperty(value = "替换方式",example = "1")
    private Integer mode = -1;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称")
    private String projectName;


    /**
     * 代码地址
     */
    @ApiModelProperty(value = "代码地址")
    private String codeUrl;

    /**
     * 文件名称
     */
    @ApiModelProperty(value = "文件名称")
    private String codeName;

    /**
     * git地址
     */
    @ApiModelProperty(value = "git地址")
    private String gitUrl;

    /**
     * 模块数 -1不清楚
     */
    @ApiModelProperty(value = "模块数",example = "1")
    private Integer moduleNum = -1;

    /**
     * 原开发费用 -1不清楚
     */
    @ApiModelProperty(value = "原开发费用",example = "1")
    private Integer cost = -1;

    /**
     * 开发单位是否在本地int 1:是 2：否 -1不清楚
     */
    @ApiModelProperty(value = "开发单位是否在本地int",example = "1")
    private Integer address = -1;

    /**
     * 本地开发单位联系方式
     */
    @ApiModelProperty(value = "本地开发单位联系人")
    private String localContact;
    /**
     * 本地开发单位联系方式
     */
    @ApiModelProperty(value = "本地开发单位联系方式")
    private String localPhone;

    /**
     * 是否为涉密信息系统 int 1:是 2：否
     */
    @ApiModelProperty(value = "是否为涉密信息系统",example = "1")
    private Integer secret = -1;

    /**
     * 容灾能力 int 1:是 2：否 -1不清楚
     */
    @ApiModelProperty(value = "容灾能力",example = "1")
    private Integer disasterTolerance = -1;

    /**
     * -1不清楚
     * 安全能力
     * 1：无
     * 2：弱
     * 3：强
     */
    @ApiModelProperty(value = "安全能力",example = "1")
    private Integer safe = -1;

    /**
     * 架构 -1不清楚
     */
    @ApiModelProperty(value = "架构",example = "1")
    private Integer framework = -1;

    /**
     * 该应用类型
     */
    @ApiModelProperty(value = "该应用类型")
    private List<Integer> applicationType = new ArrayList<>();

    /**
     * 运行时间 -1不清楚
     */
    @ApiModelProperty(value = "运行时间",example = "1")
    private Integer time = -1;

    /**
     * 数据库表数量 -1不清楚
     */
    @ApiModelProperty(value = "数据库表数量",example = "1")
    private Integer tableNum = -1;

    /**
     * 数据库数据量 -1不清楚
     */
    @ApiModelProperty(value = "数据库数据量",example = "1")
    private Integer databaseNum = -1;
    /*
    详细填写
     */

    /**
     * 系统部署架构
     */
    @ApiModelProperty(value = "系统部署架构")
    private SystemStructure systemStructure = new SystemStructure();

    /**
     * 前端浏览器相关
     */
    @ApiModelProperty(value = "前端浏览器相关")
    private Browser browser = new Browser();

    /**
     * 中间件/API
     */
    @ApiModelProperty(value = "中间件")
    private Middleware middleware = new Middleware();

    /**
     * 数据库相关
     */
    @ApiModelProperty(value = "数据库相关")
    private Database database = new Database();

    /**
     * 迁移策略 1：休息日或晚间切换 2:暂停服务 3:平滑过渡 -1不清楚
     */
    @ApiModelProperty(value = "迁移策略",example = "1")
    private Integer strategy = -1;
    @ApiModelProperty(value = "RTO")
    private Integer rto;
    @ApiModelProperty(value = "RPO")
    private Integer rpo;
    /**
     * 额外申请
     */
    @ApiModelProperty(value = "额外申请")
    private Apply apply = new Apply();

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称")
    private String unitName;
    /**
     * 单位联系方式
     */
    private String unitPhone;
    /**
     * 单位联系人
     */
    private String unitContent;
    /**
     * 原应用是否通过等级保护/分级保护应用测评
     *  -1、我不清楚 1、是 2、否
     */
    @ApiModelProperty(value = "原应用是否通过等级保护/分级保护应用测评 -1、我不清楚 1、是 2、否")
    private Integer gradeProtection=-1;
    /**
     * 开发周期
     */
    @ApiModelProperty(value = "开发周期")
    private Integer cycle;
    /**
     * 原开发语言体系
     */
    @ApiModelProperty(value = "原开发语言体系")
    private DevelopLanguageSystem developLanguageSystem=new DevelopLanguageSystem();
    /**
     * 本地操作系统依赖
     */
    @ApiModelProperty(value = "本地操作系统依赖")
    private LocalSystemDep localSystemDep=new LocalSystemDep();

}
