package com.zjty.inspect.enums;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "bs浏览器技术名称")
@Getter
public enum  FontTechnologyEnum {
    BUSHEJI("不涉及",1),
    NONE("无",-1),
    JS("JS",2),
    CSS("CSS",3),
    ASP("ASP",4),
    HTML("HTML",5),
    JQUERY("JQuery框架",6),
    ANGULAR("Angular框架",8),
    VUE("VUE框架",9),
    REACT("React框架",10),
    QUCIK("QucikUI框架",11),
    LAY("LayUI框架",12),
    AVALON("Avalon框架",13),
    DOJO("Dojo框架",14),
    EMBER("Ember框架",15),
    AURELIA("Aurelia框架",16),
    QITA("其他：请在备注中填写,如需填写多个,请以逗号分隔",17);
    //描述
    private String name;
    //序号
    private Integer code;

    FontTechnologyEnum() {
    }
    private static Map<String,FontTechnologyEnum> fontTechnologyEnumMap=new HashMap<>();
    private static Map<Integer,FontTechnologyEnum> fontTechnologyEnumCodeMap=new HashMap<>();

    static {
        for (FontTechnologyEnum fontTechnologyEnum : FontTechnologyEnum.values()) {
            fontTechnologyEnumMap.put(fontTechnologyEnum.getName(),fontTechnologyEnum);
            fontTechnologyEnumCodeMap.put(fontTechnologyEnum.code,fontTechnologyEnum);
        }
    }
    FontTechnologyEnum(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public static FontTechnologyEnum getByName(String name){
        FontTechnologyEnum fontTechnologyEnum = fontTechnologyEnumMap.get(name);
        if(fontTechnologyEnum==null){
            return NONE;
        }
        return fontTechnologyEnum;
    }
    public static FontTechnologyEnum getByCode(Integer code){
        FontTechnologyEnum fontTechnologyEnum = fontTechnologyEnumCodeMap.get(code);
        if(fontTechnologyEnum==null){
            return NONE;
        }
        return fontTechnologyEnum;
    }
}
