package com.zjty.inspect.utils;

import com.alibaba.fastjson.JSON;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.List;
import java.util.Objects;

/**
 * 应用系统改造替换工作量根据表单计算
 * @Author wyl
 * @Date 2020-03-6 14:20
 */
public class WorkLoadUtil {
    Logger logger = LoggerFactory.getLogger(getClass());
    private double calculate(Reform reform){
        logger.info("分值计算，输入："+JSON.toJSON(reform));
        double score = 0;
        /**
         * 系统部署架构，其他需求，分布式、负载均衡、容灾每个+10
         */
        SystemStructure systemStructure = reform.getSystemStructure();
        if(systemStructure!=null) {
            //分布式
            if (systemStructure.getDistributed() != null && systemStructure.getDistributed() == 1) {
                score += 10;
                logger.info("分布式+10：" + score);
            }
            //负载均衡
            if (systemStructure.getLoadBalance() != null && systemStructure.getLoadBalance() == 1) {
                score += 10;
                logger.info("负载均衡+10：" + score);
            }
            //容灾
            if (systemStructure.getDisaster() != null && systemStructure.getDisaster() == 1) {
                score += 10;
                logger.info("容灾+10：" + score);
            }
        }
        /**
         * 前端浏览器相关
         */
        Browser browser = reform.getBrowser();
        if(browser!=null) {
            //如果原浏览器包含IE，+10
            List<CompatibleBrowser> compatibleBrowsers = browser.getCompatibleBrowsers();
            if (compatibleBrowsers!=null&&compatibleBrowsers.contains(CompatibleBrowser.IETRIDENT)) {
                score += 10;
                logger.info("包含IE+10：" + score);
            }
            /*更多需求，每个+1*/
            //地理信息系统
            if (browser.getGeography()!=null&&browser.getGeography() == 1) {
                score += 1;
                logger.info("浏览器-地理信息系统+1：" + score);
            }
            //调用外设
            if (browser.getPeripheral()!=null&&browser.getPeripheral() == 1) {
                score += 1;
                logger.info("浏览器-调用外设+1：" + score);
            }
            //动画
            if (browser.getAnimation()!=null&&browser.getAnimation() == 1) {
                score += 1;
                logger.info("浏览器-动画+1：" + score);
            }
            //3D展示
            if (browser.getThreeD()!=null&&browser.getThreeD() == 1) {
                score += 1;
                logger.info("浏览器-3D展示+1：" + score);
            }
            //公文实现与编辑
            if (browser.getDocument()!=null&&browser.getDocument() == 1) {
                score += 1;
                logger.info("浏览器-公文编辑+1：" + score);
            }
            //多媒体
            if (browser.getMedia()!=null&&browser.getMedia() == 1) {
                score += 1;
                logger.info("浏览器-多媒体+1：" + score);
            }
            //flash
            if (browser.getFlash()!=null&&browser.getFlash() == 1) {
                score += 1;
                logger.info("浏览器-flash+1：" + score);
            }
            //其他
            if (browser.getOtherDemand()!=null&&browser.getOtherDemand() == 1) {
                score += 1;
                logger.info("浏览器-其他+1：" + score);
            }
        }
        /**
         * 中间件，除Tomcat外每个+5;更多需求，每个+10
         */
        Middleware middleware = reform.getMiddleware();
        if(middleware!=null) {
            List<MiddlewareEnum> middlewareEnums = middleware.getMiddlewareEnums();
            int effectMidNum = 0;
            if(middlewareEnums!=null) {
                effectMidNum = middlewareEnums.size();
                if (middlewareEnums.contains(MiddlewareEnum.TOMCAT)) {
                    effectMidNum--;
                }
            }
            if (middleware.getOtherMiddleware() != null && !middleware.getOtherMiddleware().trim().equals("")) {
                effectMidNum++;
            }
            score += effectMidNum * 5;
            logger.info("中间件-数量*5：" + effectMidNum + "\t" + score);
            /*更多需求*/
            //Web集群
            if (middleware.getWeb()!=null&&middleware.getWeb() == 1) {
                score += 10;
                logger.info("中间件-Web集群+10：" + score);
            }
            //Jndi集群
            if (middleware.getJndi()!=null&&middleware.getJndi() == 1) {
                score += 10;
                logger.info("中间件-Jndi集群+10：" + score);
            }
            //Jms集群
            if (middleware.getJms()!=null&&middleware.getJms() == 1) {
                score += 10;
                logger.info("中间件-Jms集群+10：" + score);
            }
            //消息路由
            if (middleware.getRoute()!=null&&middleware.getRoute() == 1) {
                score += 10;
                logger.info("中间件-消息路由+10：" + score);
            }
        }
        /**
         * 数据库相关，除mysql每个+10；小需求每个+2；更多需求每个+10
         */
        Database database = reform.getDatabase();
        if(database!=null) {
            List<DatabaseType> databaseType = database.getDatabaseType();
            int effectDatabaseNum = 0;
            if(databaseType!=null) {
                effectDatabaseNum = databaseType.size();
                if (databaseType.contains(DatabaseType.MYSQL)) {
                    effectDatabaseNum--;
                }
            }
            if (database.getOtherType() != null && !database.getOtherType().trim().equals("")) {
                effectDatabaseNum++;
            }
            score += effectDatabaseNum * 10;
            logger.info("数据库-数量*10：" + effectDatabaseNum + "\t" + score);
            /*小需求，每个+2*/
            //视图
            if (database.getView()!=null&&database.getView() == 1) {
                score += 2;
                logger.info("数据库-视图+2：" + score);
            }
            //存储过程
            if (database.getStorage()!=null&&database.getStorage() == 1) {
                score += 2;
                logger.info("数据库-存储过程+2：" + score);
            }
            //函数
            if (database.getFunction()!=null&&database.getFunction() == 1) {
                score += 2;
                logger.info("数据库-函数+2：" + score);
            }
            //DbLink
            if (database.getDbLink()!=null&&database.getDbLink() == 1) {
                score += 2;
                logger.info("数据库-DBLink+2：" + score);
            }
            //定时任务
            if (database.getTimeTask()!=null&&database.getTimeTask() == 1) {
                score += 2;
                logger.info("数据库-定时任务+2：" + score);
            }
            //序列
            if (database.getSequence()!=null&&database.getSequence() == 1) {
                score += 2;
                logger.info("数据库-序列+2：" + score);
            }
            //触发器
            if (database.getTrigger()!=null&&database.getTrigger() == 1) {
                score += 2;
                logger.info("数据库-触发器+2：" + score);
            }
            /*更多需求*/
            //容灾：2主备3分布式
            if (database.getDisasterTolerance()!=null&&(database.getDisasterTolerance() == 2 || database.getDisasterTolerance() == 3)) {
                score += 10;
                logger.info("数据库-容灾-主备/分布式+10：" + score);
            }
            //安全
            if (database.getSafe()!=null&&database.getSafe() == 1) {
                score += 10;
                logger.info("数据库-安全+10：" + score);
            }
            //读写分离
            if (database.getSeparate()!=null&&database.getSeparate() == 1) {
                score += 10;
                logger.info("数据库-读写分离+10：" + score);
            }
            //更高性能
            if (database.getPerformance()!=null&&database.getPerformance() == 1) {
                score += 10;
                logger.info("数据库-更高性能+10：" + score);
            }
            //其他
            if (database.getOtherContent() != null && !database.getOtherContent().trim().equals((""))) {
                score += 10;
                logger.info("数据库-其他+10：" + score);
            }
        }
        /*迁移策略：平滑过渡+50%；短暂停顿+20%*/
        if(reform.getStrategy()!=null&&reform.getStrategy()==1){
            score+=score/2;
            logger.info("迁移策略-平滑过渡+50%："+score);
        }else if(reform.getStrategy()!=null&&reform.getStrategy()==2){
            score+=score/5;
            logger.info("迁移策略-短暂停顿+20%："+score);
        }
        return score;
    }

    //f:工作量（马）
    //r:人工费
    public void result(Reform reform,AssessmentReport report,double f,double r){
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        //nf.setRoundingMode(RoundingMode.HALF_UP);
        double calculate = 0;//calculate(reform);
        switch (reform.getStrategy()){
            case 1:
                calculate = 0;
                break;
            case 2://平滑过渡
                calculate = 50;
                break;
            case 3://短暂停止
                calculate = 20;
                break;
        }
        logger.info("计算工作量，输入："+JSON.toJSONString(report));

        //总计J = F（马） * 人工费
        double j = f/r;
        logger.info("f:"+f+"r:"+r+"总计J："+j);
        /*
            先计算难度，再算基础工作量
        */
        FrameDifficulty frameDifficulty = report.getDifficultyAssessment().getFrameDifficulty();
        //系统部署架构难度P（混合：1.1  前后分离：1）即系统评估
        double pFramework = (frameDifficulty.getDetails()== 1)?1.1:1;
        logger.info("系统部署架构难度-评估："+pFramework);
        frameDifficulty.setSystemEvaluation(Double.valueOf(nf.format(pFramework)));
        //系统部署架构难度e（分布式 0.2 负载均衡 0.1 容灾0.1 其他0.1） e = 1.2*1.1*1.1*1.1 即用户额外信息
        double eFramework = 1*frameDifficulty.getDistributed()==1?1.2:1*frameDifficulty.getLoadBalance()==1?1.1:1*frameDifficulty.getDisaster()==1?1.1:1;
        logger.info("系统部署架构难度-用户额外："+eFramework);
        frameDifficulty.setMessage(Double.valueOf(nf.format(eFramework)));
        //系统部署架构综合难度 p*e
        double multipleFramework = /*Math.sqrt(*/pFramework*eFramework/*)*/;
        logger.info("系统部署架构难度-综合（两个难度相乘）："+multipleFramework);
        frameDifficulty.setDifficulty(Double.valueOf(nf.format(multipleFramework)));
        //工作量2*j*(z-1)
        double frameworkWorkload = 2*j*(multipleFramework-1);
        logger.info("系统部署工作量：2*j"+j+"*(综合难度-1):"+frameworkWorkload);
        frameDifficulty.setLoad(Double.valueOf(nf.format(frameworkWorkload)));

        BrowserDifficulty browserDifficulty = report.getDifficultyAssessment().getBrowserDifficulty();
        //浏览器难度P（0.001*样式数量+0.01*API数量+0.01*插件数量+1） max=1.3
        double pBrowser = 0.001*browserDifficulty.getStyle()+0.01*browserDifficulty.getApi()+0.01*browserDifficulty.getPlugInUnit()+1;
        pBrowser = pBrowser>1.3?1.3:pBrowser;
        logger.info("浏览器难度-评估："+pBrowser);
        browserDifficulty.setSystemEvaluation(Double.valueOf(nf.format(pBrowser)));
        //浏览器难度e（1+需求分数/100）*（1+需求分数/100）           max=1.3
        double eBrowser = (1.0+(browserDifficulty.getGeography()!=null&&browserDifficulty.getGeography()==1.0?1:0)/100)*
                (1.0+(browserDifficulty.getPeripheral()!=null&&browserDifficulty.getPeripheral()==1?1.0:0)/100)*
                (1.0+(browserDifficulty.getAnimation()!=null&&browserDifficulty.getAnimation()==1?1.0:0)/100)*
                (1.0+(browserDifficulty.getThreeD()!=null&&browserDifficulty.getThreeD()==1?1.0:0)/100)*
                (1.0+(browserDifficulty.getDocument()!=null&&browserDifficulty.getDocument()==1?1.0:0)/100)*
                (1.0+(browserDifficulty.getMedia()!=null&&browserDifficulty.getMedia()==1?1.0:0)/100)*
                (1.0+(browserDifficulty.getFlash()!=null&&browserDifficulty.getFlash()==1?1.0:0)/100)*
                (1.0+(browserDifficulty.getOtherDemand()!=null&&browserDifficulty.getOtherDemand()==1?1.0:0)/100);
        eBrowser = eBrowser>1.3?1.3:eBrowser;
        logger.info("浏览器难度-用户额外："+eBrowser);
        browserDifficulty.setMessage(Double.valueOf(nf.format(eBrowser)));
        //浏览器综合难度 p*e开根号
        double multipleBrowser = Math.sqrt(pBrowser*eBrowser);
        logger.info("浏览器难度-综合（两个难度相乘开根号）："+multipleBrowser);
        browserDifficulty.setDifficulty(Double.valueOf(nf.format(multipleBrowser)));
        //工作量2*j*(z-1)
        double browserWorkload = 2*j*(multipleBrowser-1);
        logger.info("浏览器工作量：2*j"+j+"*(综合难度-1)："+browserWorkload);
        browserDifficulty.setLoad(Double.valueOf(nf.format(browserWorkload)));

        MiddlewareDifficulty middlewareDifficulty = report.getDifficultyAssessment().getMiddlewareDifficulty();
        //中间件系统评估P (1+0.001*依赖数量）*(1+0.001*依赖数量）
        double pMiddle = 1;
//        for(DependOnNum dependOnNum:middlewareDifficulty.getDependOnNum()){
//            pMiddle*=(1.0+0.001*dependOnNum.getNum());
//        }
        pMiddle*=(1.0+0.001*middlewareDifficulty.getDependOnNum());
        pMiddle = pMiddle>1.3?1.3:pMiddle;
        logger.info("中间件难度-评估："+pMiddle);
        middlewareDifficulty.setSystemEvaluation(Double.valueOf(nf.format(pMiddle)));
        //中间件系统评估e （1+需求分数/100）*（1+需求分数/100）           max=1.3
        double emiddle = (1.0+(middlewareDifficulty.getWeb()==1.0?1:0)/100)*
                (1.0+(middlewareDifficulty.getJms()==1?1.0:0)/100)*
                (1.0+(middlewareDifficulty.getJndi()==1?1.0:0)/100)*
                (1.0+(middlewareDifficulty.getRoute()==1?1.0:0)/100);
        emiddle = emiddle>1.3?1.3:emiddle;
        logger.info("中间件难度-用户额外："+emiddle);
        middlewareDifficulty.setMessage(Double.valueOf(nf.format(emiddle)));
        //中间件综合难度 p*e开根号
        double multipleMiddle = Math.sqrt(pMiddle*emiddle);
        logger.info("中间件难度-综合："+multipleMiddle);
        middlewareDifficulty.setDifficulty(Double.valueOf(nf.format(multipleMiddle)));
        //工作量2*j*(z-1)
        double middleWorkload = 2*j*(multipleMiddle-1);
        logger.info("中间件工作量：2*j"+j+"*(综合难度-1)："+middleWorkload);
        middlewareDifficulty.setLoad(Double.valueOf(nf.format(middleWorkload)));

        DatabaseDifficulty databaseDifficulty = report.getDifficultyAssessment().getDatabaseDifficulty();
        //数据库e （1+需求/100）*...*(1+需求/100)
        double eDatabase = 1;
        eDatabase *= (1.0+(databaseDifficulty.getSafe()==1?1.0:0)/100)*
                (1.0+(databaseDifficulty.getSeparate()==1?1.0:0)/100)*
                (1.0+(databaseDifficulty.getPerformance()==1?1.0:0)/100)*
                (1.0+((databaseDifficulty.getOtherContent()!=null&&!databaseDifficulty.getOtherContent().trim().equals("")) ?1.0:0)/100);
        logger.info("数据库难度："+eDatabase);
        databaseDifficulty.setDifficulty(Double.valueOf(nf.format(eDatabase)));
        //工作量2*j*(z-1)
        double databaseWorkload = 2*j*(eDatabase-1);
        logger.info("数据库工作量2*j"+j+"*(综合难度-1)："+databaseWorkload);
        databaseDifficulty.setLoad(Double.valueOf(nf.format(databaseWorkload)));

        //本地程序e (1+0.2)数量次幂  max=1.5
        ProgramDifficulty programDifficulty = report.getDifficultyAssessment().getProgramDifficulty();
        int totalNum = 0;
        for(DependOnNum dependOnNum:programDifficulty.getDependOnNum()){
//            System.out.println(dependOnNum.getName());
//            System.out.println(dependOnNum.getNum());
            if(dependOnNum.getNum()!=-1){
                totalNum += dependOnNum.getNum();
            }
        }
        logger.info(totalNum+"");
        double eProgram = Math.pow(1.2, totalNum);
        eProgram = eProgram>1.5?1.5:eProgram;
        logger.info("本地程序难度："+eProgram);
        programDifficulty.setDifficulty(Double.valueOf(nf.format(eProgram)));
        //工作量2*j*(z-1)
        double programWorkload = 2*j*(eProgram-1);
        logger.info("本地程序工作量2*j"+j+"*(综合难度-1)："+programWorkload);
        programDifficulty.setLoad(Double.valueOf(nf.format(programWorkload)));

        /*
            基础工作量评估
        */
        //开发修正系数 （本地难度系数-1）+（浏览器难度系数-1）
        double developmentCorrectionFactor = eProgram-1+multipleBrowser-1;
        logger.info("开发修正系数 （本地难度系数-1）+（浏览器难度系数-1）："+developmentCorrectionFactor);
        report.getWorkload().getDevelopment().setCorrectionFactor(Double.valueOf(nf.format(1+developmentCorrectionFactor)));
        //测试修正系数 （系统部署难度-1）+（浏览器-1）
        double testCorrectionFactor = multipleFramework-1+multipleBrowser-1;
        logger.info("测试修正系数 （系统部署难度-1）+（浏览器-1）:"+testCorrectionFactor);
        report.getWorkload().getTest().setCorrectionFactor(Double.valueOf(nf.format(1+testCorrectionFactor)));
        //部署修正系数 （迁移）/100+（系统部署-1）+中间件部署-1+数据库部署-1
        double deploymentCorrectionFactor = calculate/100+multipleFramework-1+multipleMiddle-1+eDatabase-1;
        logger.info("部署修正系数 （迁移）/100+（系统部署-1）+中间件部署-1+数据库部署-1:"+deploymentCorrectionFactor);
        report.getWorkload().getDeploy().setCorrectionFactor(Double.valueOf(nf.format(1+deploymentCorrectionFactor)));
        //开发的开发量 J*（开发修正系数+0.4）
        double developmentWorkload = j*(developmentCorrectionFactor+0.4);
        logger.info("开发的开发量 J*（开发修正系数+0.4）:"+developmentWorkload);
        report.getWorkload().getDevelopment().setDevelopmentVolume(Double.valueOf(nf.format(developmentWorkload)));
        //测试的开发量 J*（测试修正系数+0.3）
        double testWorkload = j*(testCorrectionFactor+0.3);
        logger.info("测试的开发量 J*（测试修正系数+0.3）:"+testWorkload);
        report.getWorkload().getTest().setDevelopmentVolume(Double.valueOf(nf.format(testWorkload)));
        //部署的开发量 J*（部署修正系数+0.3）
        double deploymentWorkload = j*(deploymentCorrectionFactor+0.3);
        logger.info("部署的开发量 J*（部署修正系数+0.3）:"+deploymentWorkload);
        report.getWorkload().getDeploy().setDevelopmentVolume(Double.valueOf(nf.format(deploymentWorkload)));
        //合计的开发量 总数
        double totalWorkload = developmentWorkload+testWorkload+deploymentWorkload;
        logger.info("合计的开发量 总数:"+totalWorkload);
        report.getWorkload().getTotal().setDevelopmentVolume(Double.valueOf(nf.format(totalWorkload)));
        report.getWorkload().getTotal().setCorrectionFactor(-1);


        /*
            建议：
        */
        StringBuilder string = new StringBuilder("本系统通过源代码评估适配关键技术"+report.getTechnologyList().getTechnologyReports().size()+"项，"
                +"其中");
        for(TechnologyReport technologyReport:report.getTechnologyList().getTechnologyReports()){
            string .append( technologyReport.getTechnology()+"修改项"+technologyReport.getTechnologyContents().size()+"个，");
        }
        report.getTechnologyList().setDes(string.substring(0,string.length()-1)+"。");
        String type = "";
        if(report.getType()==1){
            type = "改造";
        }else if(report.getType()==2){
            type = "适配";
        }
        String workloadDes = "本系统通过选择"+type+"方式部署到国产化安全自主可控环境上。代码层面的关键工作量包含{开发量}*修正系数人工月（包含对不可预见的估算）";
        report.getWorkload().setDes(workloadDes);
        double multipleHardrage = totalWorkload*r/f;
        report.getDifficultyAssessment().setDes("本系统通过源代码评估，及用户额外信息提供，认为综合难度系数："+Double.valueOf(nf.format(multipleHardrage)));
        /**
         * 人工单价、基础工作量（人月）、难度系数、额外申请（万元）、预算费用 的计算值
         */
        report.getManufacturingCost().getArtificial().setCalculation(Double.valueOf(nf.format(r)));
        report.getManufacturingCost().getArtificial().setAdjustment(Double.valueOf(nf.format(r)));
        report.getManufacturingCost().getWorkLoad().setCalculation(Double.valueOf(nf.format(totalWorkload)));
        report.getManufacturingCost().getWorkLoad().setAdjustment(Double.valueOf(nf.format(totalWorkload)));
        report.getManufacturingCost().getDegreeOfDifficulty().setCalculation(Double.valueOf(nf.format(multipleHardrage)));
        report.getManufacturingCost().getDegreeOfDifficulty().setAdjustment(Double.valueOf(nf.format(multipleHardrage)));
        report.getManufacturingCost().getApply().setCalculation(Double.valueOf(nf.format(reform.getApply().getCost()==-1?0:reform.getApply().getCost())));
        report.getManufacturingCost().getApply().setAdjustment(0);
        Double totalManey = Double.valueOf(nf.format(r * totalWorkload + (reform.getApply().getCost() == -1 ? 0 : reform.getApply().getCost())));
        report.getManufacturingCost().getBudgetaryCost().setCalculation(totalManey);
        report.getManufacturingCost().getBudgetaryCost().setAdjustment(Double.valueOf(nf.format(r*totalWorkload)));
        logger.info("人工费："+r+"万元");
        logger.info("额外申请"+(reform.getApply().getCost()==-1?0:reform.getApply().getCost())+"万元");
        logger.info("费用总计"+(r*totalWorkload+reform.getApply().getCost()));

        report.setBudget(totalManey.toString());

        //修正系数+1
        //额外申请原因
    }

    public static void main(String[] args) {
        WorkLoadUtil workLoadUtil = new WorkLoadUtil();
        String reform = "{\n" +
                "\t\"mode\":1,\n" +
                "\t\"reformUrl\":\"www\",\n" +
                "\t\"adaptationUrl\":\"\",\n" +
                "\t\"projectName\":\"\",\n" +
                "\t\"uploadType\":\"\",\n" +
                "\t\"codeUrl\":\"\",\n" +
                "\t\"moduleNum\":\"\",\n" +
                "\t\"language\":\"\",\n" +
                "\t\"cost\":2.3,\n" +
                "\t\"cycle\":1,\n" +
                "\t\"serverNum\":1,\n" +
                "\t\"applicationType\":\"OA\",\n" +
                "\t\"address\":1,\n" +
                "\t\"secret\":1,\n" +
                "\t\"message\":\"\",\n" +
                "\t\"systemStructure\":{\n" +
                "\t\t\"distributed\":1,\n" +
                "\t\t\"loadBanlance\":1,\n" +
                "\t\t\"disaster\":1\n" +
                "\t},\n" +
                "\t\"browser\":{\n" +
//                "\t\t\"compatibleBrowsers\":\"IETRIDENT\",\n" +
//                "\t\t\"peripheral\":1\n" +
                "\t},\n" +
                "\t\"middleware\":{\n" +
                "\t\t\"web\":1\n" +
                "\t},\n" +
                "\t\"database\":{\n" +
                "\t\t\"otherType\":\"aaa\"\n" +
                "\t},\n" +
                "\t\"strategy\":1\n" +
                "}";
        workLoadUtil.result(JSON.parseObject(reform,Reform.class),new AssessmentReport(),1,1);
    }
}
