package com.zjty.inspect.controller;

import com.zjty.inspect.aop.AuthAnnotation;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.service.RuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * 规则库设置
 * @author Mcj
 * @date 2020-02-26 14:42
 */

@RestController
@RequestMapping("/rule")
@Api(value = "规则页面管理接口",description = "规则页面管理接口,提供页面的增、删、改、查")
public class RuleController {

    @Autowired
    private RuleService ruleService;

    /**
     * test
     * 新增规则
     * @param
     * @return
     */
    @PostMapping
    @ApiOperation("新增规则")
    public ResponseEntity rule(@RequestBody Rule rule){
        Rule rule1 = ruleService.addRulePlus(rule);
        if(rule1!=null){
            return ResponseEntity.ok(rule1);
        }
        return ResponseEntity.status(500).build();
    }
    /**
     * 修改规则
     * @param rule 规则封装
     * @return
     */
    @PostMapping(value = "/update")
    @ApiOperation("修改规则")
    public ResponseEntity update(@RequestBody Rule rule){
        ruleService.upRulePlus(rule);
        return ResponseEntity.ok(200);
    }
    /**
     * 根据id删除规则
     * @param id
     * @return
     */
    @ApiOperation("根据数据封装删除规则")
    @DeleteMapping
    public ResponseEntity deleteByQo(@RequestBody String id){
        ruleService.deleteRulePlus(id);
        return ResponseEntity.ok(200);
    }


    /**
     * 分页+多条件查询
     * @param searchMap 查询条件封装
     * @param page 页码
     * @param size 页大小
     * @return 分页结果
     */
    @ApiOperation("分页查询页面列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="page",value = "页码",required=true,paramType="path",dataType="int"),
            @ApiImplicitParam(name="size",value = "每页记录数",required=true,paramType="path",dataType="int")
    })
    @RequestMapping(value="/search/{page}/{size}",method=RequestMethod.POST)
    public ResponseEntity findSearch(@RequestBody Map searchMap , @PathVariable int page, @PathVariable int size){
        Page<Rule> search = ruleService.findSearch(searchMap, page, size);
        return  ResponseEntity.ok(search);
    }

    /**
     * 导出所有规则
     * @return 规则
     */
    @ApiOperation("导出所有规则")
    @GetMapping("/export")
    public ResponseEntity exportAllRules(){
        String path = ruleService.exportData();
        return ResponseEntity.ok(path);
    }
    @PostMapping("/importRules")
    @ApiOperation("导入所有规则")
    public ResponseEntity importRules(@RequestParam("file") MultipartFile file){
        ruleService.importRules(file);
        return null;
    }
}
