package com.zjty.inspect.entity;

import com.zjty.inspect.enums.ApplicationType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <h4>Description : 应用系统改造替换表单</h4>
 *
 * @author : czq
 * @Date : 2020-03-05 16:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Reform {

    /**
     * 替换方式  int（1：改造 2：适配）
     */
    private Integer mode ;

    /**
     * 改造解释链接
     */
    private String reformUrl;

    /**
     * 适配解释链接
     */
    private String adaptationUrl;

    /**
     * 系统名称
     */
    private String projectName;

    /**
     * 上传类型
     */
    private String uploadType;

    /**
     * 代码地址
     */
    private String codeUrl;

    /**
     * 模块数
     */
    private String moduleNum;

    /**
     *开发语言
     */
    private String language;

    /**
     * 原开发费用
     */
    private double cost;

    /**
     * 原开发周期
     */
    private Integer cycle;

    /**
     * 服务设备台数
     */
    private Integer serverNum;

    /**
     * 该应用类型
     */
    private ApplicationType applicationType;

    /**
     * 开发单位是否在本地int 1:是 2：否
     */
    private Integer address;

    /**
     * 是否为涉密信息系统 int 1:是 2：否
     */
    private Integer secret;

    /**
     * 详细填写
     */
    private String message;

    /**
     * 系统部署架构
     */
    private SystemStructure systemStructure;

    /**
     * 前端浏览器相关
     */
    private Browser browser;

    /**
     * 中间件/API
     */
    private Middleware middleware;

    /**
     * 数据库相关
     */
    private Database database;

    /**
     * 迁移策略 1：休息日 2：晚间切换
     */
    private Integer strategy;
    /**
     * 额外申请
     */
    private Apply apply;

}
