package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <h4>Description : 原系统架构</h4>
 *
 * @author : CZQ
 * @Date : 2020-03-05 16:58
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "原系统架构")
public class SystemStructure {


    /**
     * 应用服务器
     */
    private Details application;

    /**
     * 数据库服务器
     */
    private Details database;

    /**
     * SLB
     */
    private Details slb;
    /**
     * cdn
     */
    private Details cdn;
    /**
     * V2/P/S（访问代理服务设备）
     */
    private Details vps;

    /**
     * 存储
     */
    private Details storage;

    /**
     * 其他服务设备
     */
    private Details otherEquipment;

    /*
    更多需求
     */

    /**
     * 分布式 int 1：是 2：否
     */
    @ApiModelProperty(value = "权限",example = "1")
    private Integer distributed = -1;

    /**
     * 负载均衡 int 1：是 2：否
     */
    @ApiModelProperty(value = "权限",example = "1")
    private Integer loadBalance = -1;

    /**
     * 容灾
     * 1：无0，有+0.05
     * 2：有0，无-0.05
     * 3：有0，无-0.1
     */
    @ApiModelProperty(value = "权限",example = "1")
    private Integer disaster = -1;

    /**
     * 其他需求
     */
    private String otherDemand;
}
